/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import java.io.IOException;

public class YMLWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return this._formatWhitespaceAroundBracketAndCurlyBrace(content);
    }

    private String _formatWhitespaceAroundBracketAndCurlyBrace(String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                line = this._removeWhitespaceAfterOpenBracket(line);
                line = this._removeWhitespaceAfterOpenCurlyBrace(line);
                line = this._removeWhitespaceBeforeCloseBracket(line);
                line = this._removeWhitespaceBeforeCloseCurlyBrace(line);
                sb.append(line);
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _removeWhitespaceAfterOpenBracket(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("elif [") || trimmedLine.startsWith("if [")) {
            return line;
        }
        int x = line.indexOf("[ ");
        if (x == -1 || ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "[", "]") != 0) {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }

    private String _removeWhitespaceAfterOpenCurlyBrace(String line) {
        int x = line.indexOf("{ ");
        if (x == -1) {
            return line;
        }
        if (x == 0) {
            return StringUtil.replaceFirst(line, " ", "", 0);
        }
        if (ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "{", "}") != 0) {
            return line;
        }
        char c = line.charAt(x - 1);
        if (c == '{') {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }

    private String _removeWhitespaceBeforeCloseBracket(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("elif [") || trimmedLine.startsWith("if [")) {
            return line;
        }
        int x = line.indexOf(" ]");
        if (x == -1 || ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "[", "]") != 0) {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }

    private String _removeWhitespaceBeforeCloseCurlyBrace(String line) {
        int x = line.indexOf(" }");
        if (x == -1 || ToolsUtil.isInsideQuotes(line, x) || this.getLevel(line, "{", "}") != 0) {
            return line;
        }
        if (x == line.length() - 2) {
            return StringUtil.replaceFirst(line, " ", "", x);
        }
        char c = line.charAt(x + 2);
        if (c == '}') {
            return line;
        }
        return StringUtil.replaceFirst(line, " ", "", x);
    }
}

