/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.petra.string.StringBundler;
import java.io.IOException;
import java.io.Reader;

public class UnsyncBufferedReader
extends Reader {
    protected char[] buffer;
    protected int firstInvalidIndex;
    protected int index;
    protected int markLimitIndex = -1;
    protected Reader reader;
    private static final int _DEFAULT_BUFFER_SIZE = 8192;

    public UnsyncBufferedReader(Reader reader) {
        this(reader, 8192);
    }

    public UnsyncBufferedReader(Reader reader, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 0");
        }
        this.reader = reader;
        this.buffer = new char[size];
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.buffer = null;
        }
    }

    @Override
    public void mark(int markLimit) throws IOException {
        if (markLimit < 0) {
            throw new IllegalArgumentException("Mark limit is less than 0");
        }
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (markLimit == 0) {
            return;
        }
        this.markLimitIndex = markLimit;
        if (this.index == 0) {
            return;
        }
        int available = this.firstInvalidIndex - this.index;
        if (available > 0) {
            System.arraycopy(this.buffer, this.index, this.buffer, 0, available);
            this.index = 0;
            this.firstInvalidIndex = available;
        } else {
            this.firstInvalidIndex = 0;
            this.index = 0;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (this.index >= this.firstInvalidIndex) {
            this.fillInBuffer();
            if (this.index >= this.firstInvalidIndex) {
                return -1;
            }
        }
        return this.buffer[this.index++];
    }

    @Override
    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    @Override
    public int read(char[] chars, int offset, int length) throws IOException {
        int currentRead;
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (length <= 0) {
            return 0;
        }
        int read = 0;
        do {
            if ((currentRead = this.readOnce(chars, offset + read, length - read)) > 0) continue;
            if (read != 0) break;
            read = currentRead;
            break;
        } while (this.reader.ready() && (read += currentRead) < length);
        return read;
    }

    public String readLine() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        StringBundler sb = null;
        while (true) {
            int y;
            if (this.index >= this.firstInvalidIndex) {
                this.fillInBuffer();
            }
            if (this.index >= this.firstInvalidIndex) {
                if (sb != null && sb.index() > 0) {
                    return sb.toString();
                }
                return null;
            }
            boolean hasLineBreak = false;
            char lineEndChar = '\u0000';
            int x = this.index;
            for (y = this.index; y < this.firstInvalidIndex; ++y) {
                lineEndChar = this.buffer[y];
                if (lineEndChar != '\n' && lineEndChar != '\r') continue;
                hasLineBreak = true;
                break;
            }
            String line = new String(this.buffer, x, y - x);
            this.index = y;
            if (hasLineBreak) {
                ++this.index;
                if (lineEndChar == '\r' && this.index < this.buffer.length && this.buffer[this.index] == '\n') {
                    ++this.index;
                }
                if (sb == null) {
                    return line;
                }
                sb.append(line);
                return sb.toString();
            }
            if (sb == null) {
                sb = new StringBundler();
            }
            sb.append(line);
        }
    }

    @Override
    public boolean ready() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        return this.index < this.firstInvalidIndex || this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (this.markLimitIndex < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.index = 0;
    }

    @Override
    public long skip(long skip) throws IOException {
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip is less than 0");
        }
        if (this.reader == null) {
            throw new IOException("Reader is null");
        }
        if (skip == 0L) {
            return 0L;
        }
        long available = this.firstInvalidIndex - this.index;
        if (available <= 0L) {
            if (this.markLimitIndex < 0) {
                return this.reader.skip(skip);
            }
            this.fillInBuffer();
            available = this.firstInvalidIndex - this.index;
            if (available <= 0L) {
                return 0L;
            }
        }
        if (available < skip) {
            skip = available;
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }

    protected void fillInBuffer() throws IOException {
        if (this.markLimitIndex < 0) {
            this.firstInvalidIndex = 0;
            this.index = 0;
            int number = this.reader.read(this.buffer);
            if (number > 0) {
                this.firstInvalidIndex = number;
            }
            return;
        }
        if (this.index >= this.markLimitIndex) {
            this.markLimitIndex = -1;
            this.firstInvalidIndex = 0;
            this.index = 0;
        } else if (this.index == this.buffer.length) {
            int newBufferSize = this.buffer.length * 2;
            if (newBufferSize > this.markLimitIndex) {
                newBufferSize = this.markLimitIndex;
            }
            char[] newBuffer = new char[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.firstInvalidIndex = this.index;
        int number = this.reader.read(this.buffer, this.index, this.buffer.length - this.index);
        if (number > 0) {
            this.firstInvalidIndex += number;
        }
    }

    protected int readOnce(char[] chars, int offset, int length) throws IOException {
        int available = this.firstInvalidIndex - this.index;
        if (available <= 0) {
            if (this.markLimitIndex < 0 && length >= this.buffer.length) {
                return this.reader.read(chars, offset, length);
            }
            this.fillInBuffer();
            available = this.firstInvalidIndex - this.index;
            if (available <= 0) {
                return -1;
            }
        }
        if (length > available) {
            length = available;
        }
        System.arraycopy(this.buffer, this.index, chars, offset, length);
        this.index += length;
        return length;
    }
}

