/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FileStatefulCheck
public final class IllegalTypeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.type";
    private static final String[] DEFAULT_ILLEGAL_TYPES = new String[]{"HashSet", "HashMap", "LinkedHashMap", "LinkedHashSet", "TreeSet", "TreeMap", "java.util.HashSet", "java.util.HashMap", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.TreeSet", "java.util.TreeMap"};
    private static final String[] DEFAULT_IGNORED_METHOD_NAMES = new String[]{"getInitialContext", "getEnvironment"};
    private final Set<String> illegalClassNames = new HashSet<String>();
    private final Set<String> illegalShortClassNames = new HashSet<String>();
    private final Set<String> legalAbstractClassNames = new HashSet<String>();
    private final Set<String> ignoredMethodNames = new HashSet<String>();
    private List<Integer> memberModifiers = Collections.emptyList();
    private Pattern illegalAbstractClassNameFormat = Pattern.compile("^(.*[.])?Abstract.*$");
    private boolean validateAbstractClassNames;

    public IllegalTypeCheck() {
        this.setIllegalClassNames(DEFAULT_ILLEGAL_TYPES);
        this.setIgnoredMethodNames(DEFAULT_IGNORED_METHOD_NAMES);
    }

    public void setIllegalAbstractClassNameFormat(Pattern pattern) {
        this.illegalAbstractClassNameFormat = pattern;
    }

    public void setValidateAbstractClassNames(boolean validateAbstractClassNames) {
        this.validateAbstractClassNames = validateAbstractClassNames;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{161, 14, 30, 15, 27, 9, 180, 21, 10, 198, 199, 202};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.illegalShortClassNames.clear();
        for (String s : this.illegalClassNames) {
            if (s.indexOf(46) != -1) continue;
            this.illegalShortClassNames.add(s);
        }
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: 
            case 15: 
            case 199: {
                this.visitTypeDef(ast);
                break;
            }
            case 27: 
            case 180: {
                this.visitMethodCallOrRef(ast);
                break;
            }
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            case 10: 
            case 161: 
            case 198: 
            case 202: {
                this.visitVariableDef(ast);
                break;
            }
            case 21: {
                this.visitParameterDef(ast);
                break;
            }
            case 30: {
                this.visitImport(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private boolean isVerifiable(DetailAST methodOrVariableDef) {
        boolean result = true;
        if (!this.memberModifiers.isEmpty()) {
            DetailAST modifiersAst = methodOrVariableDef.findFirstToken(5);
            result = this.isContainVerifiableType(modifiersAst);
        }
        return result;
    }

    private boolean isContainVerifiableType(DetailAST modifiers) {
        boolean result = false;
        if (modifiers.getFirstChild() != null) {
            for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
                if (!this.memberModifiers.contains(modifier.getType())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void visitTypeDef(DetailAST typeDef) {
        if (this.isVerifiable(typeDef)) {
            DetailAST implementsClause;
            this.checkTypeParameters(typeDef);
            DetailAST extendsClause = typeDef.findFirstToken(18);
            if (extendsClause != null) {
                this.checkBaseTypes(extendsClause);
            }
            if ((implementsClause = typeDef.findFirstToken(19)) != null) {
                this.checkBaseTypes(implementsClause);
            }
        }
    }

    private void visitMethodDef(DetailAST methodDef) {
        if (this.isCheckedMethod(methodDef)) {
            this.checkClassName(methodDef);
        }
    }

    private void visitParameterDef(DetailAST parameterDef) {
        DetailAST grandParentAST = parameterDef.getParent().getParent();
        if (grandParentAST.getType() == 9 && this.isCheckedMethod(grandParentAST)) {
            this.checkClassName(parameterDef);
        }
    }

    private void visitVariableDef(DetailAST variableDef) {
        if (this.isVerifiable(variableDef)) {
            this.checkClassName(variableDef);
        }
    }

    private void visitMethodCallOrRef(DetailAST methodCallOrRef) {
        this.checkTypeArguments(methodCallOrRef);
    }

    private void visitImport(DetailAST importAst) {
        if (!IllegalTypeCheck.isStarImport(importAst)) {
            String canonicalName = IllegalTypeCheck.getImportedTypeCanonicalName(importAst);
            this.extendIllegalClassNamesWithShortName(canonicalName);
        }
    }

    private static boolean isStarImport(DetailAST importAst) {
        boolean result = false;
        DetailAST toVisit = importAst;
        while (toVisit != null) {
            if ((toVisit = IllegalTypeCheck.getNextSubTreeNode(toVisit, importAst)) == null || toVisit.getType() != 60) continue;
            result = true;
            break;
        }
        return result;
    }

    private void checkClassName(DetailAST ast) {
        DetailAST type = ast.findFirstToken(13);
        this.checkType(type);
        this.checkTypeParameters(ast);
    }

    private void checkIdent(DetailAST type) {
        FullIdent ident = FullIdent.createFullIdent(type);
        if (this.isMatchingClassName(ident.getText())) {
            this.log(ident.getDetailAst(), MSG_KEY, ident.getText());
        }
    }

    private void checkBaseTypes(DetailAST clause) {
        for (DetailAST child = clause.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() == 58) {
                this.checkIdent(child);
                continue;
            }
            if (child.getType() != 163) continue;
            TokenUtil.forEachChild(child, 164, this::checkType);
        }
    }

    private void checkType(DetailAST type) {
        this.checkIdent(type.getFirstChild());
        this.checkTypeArguments(type);
        this.checkTypeBounds(type);
    }

    private void checkTypeBounds(DetailAST type) {
        DetailAST lowerBounds;
        DetailAST upperBounds = type.findFirstToken(168);
        if (upperBounds != null) {
            this.checkType(upperBounds);
        }
        if ((lowerBounds = type.findFirstToken(169)) != null) {
            this.checkType(lowerBounds);
        }
    }

    private void checkTypeParameters(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        if (typeParameters != null) {
            TokenUtil.forEachChild(typeParameters, 166, this::checkType);
        }
    }

    private void checkTypeArguments(DetailAST node) {
        DetailAST typeArguments = node.findFirstToken(163);
        if (typeArguments == null) {
            typeArguments = node.getFirstChild().findFirstToken(163);
        }
        if (typeArguments != null) {
            TokenUtil.forEachChild(typeArguments, 164, this::checkType);
        }
    }

    private boolean isMatchingClassName(String className) {
        String shortName = className.substring(className.lastIndexOf(46) + 1);
        return this.illegalClassNames.contains(className) || this.illegalShortClassNames.contains(shortName) || this.validateAbstractClassNames && !this.legalAbstractClassNames.contains(className) && this.illegalAbstractClassNameFormat.matcher(className).find();
    }

    private void extendIllegalClassNamesWithShortName(String canonicalName) {
        if (this.illegalClassNames.contains(canonicalName)) {
            String shortName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
            this.illegalShortClassNames.add(shortName);
        }
    }

    private static String getImportedTypeCanonicalName(DetailAST importAst) {
        StringBuilder canonicalNameBuilder = new StringBuilder(256);
        DetailAST toVisit = importAst;
        while (toVisit != null) {
            if ((toVisit = IllegalTypeCheck.getNextSubTreeNode(toVisit, importAst)) == null || toVisit.getType() != 58) continue;
            if (canonicalNameBuilder.length() > 0) {
                canonicalNameBuilder.append('.');
            }
            canonicalNameBuilder.append(toVisit.getText());
        }
        return canonicalNameBuilder.toString();
    }

    private static DetailAST getNextSubTreeNode(DetailAST currentNodeAst, DetailAST subTreeRootAst) {
        DetailAST currentNode = currentNodeAst;
        DetailAST toVisitAst = currentNode.getFirstChild();
        while (toVisitAst == null) {
            toVisitAst = currentNode.getNextSibling();
            if (toVisitAst != null) continue;
            if (currentNode.getParent().equals(subTreeRootAst)) break;
            currentNode = currentNode.getParent();
        }
        return toVisitAst;
    }

    private boolean isCheckedMethod(DetailAST ast) {
        String methodName = ast.findFirstToken(58).getText();
        return this.isVerifiable(ast) && !this.ignoredMethodNames.contains(methodName) && !AnnotationUtil.containsAnnotation(ast, "Override");
    }

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        Collections.addAll(this.illegalClassNames, classNames);
    }

    public void setIgnoredMethodNames(String ... methodNames) {
        this.ignoredMethodNames.clear();
        Collections.addAll(this.ignoredMethodNames, methodNames);
    }

    public void setLegalAbstractClassNames(String ... classNames) {
        Collections.addAll(this.legalAbstractClassNames, classNames);
    }

    public void setMemberModifiers(String modifiers) {
        this.memberModifiers = Stream.of(modifiers.split(",")).map(String::trim).filter(token -> !token.isEmpty()).map(TokenUtil::getTokenId).collect(Collectors.toList());
    }
}

