/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.configuration;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.configuration.SourceCheckConfiguration;
import com.liferay.source.formatter.check.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ConfigurationLoader {
    public static SourceFormatterConfiguration loadConfiguration(String fileName) throws DocumentException, IOException {
        ClassLoader classLoader = ConfigurationLoader.class.getClassLoader();
        String content = StringUtil.read(classLoader.getResourceAsStream(fileName));
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            throw new DocumentException();
        }
        SourceFormatterConfiguration sourceFormatterConfiguration = new SourceFormatterConfiguration();
        Element rootElement = document.getRootElement();
        for (Element sourceProcessorElement : rootElement.elements("source-processor")) {
            String sourceProcessorName = sourceProcessorElement.attributeValue("name");
            for (Element checkElement : sourceProcessorElement.elements("check")) {
                Element categoryElement = checkElement.element("category");
                SourceCheckConfiguration sourceCheckConfiguration = new SourceCheckConfiguration(categoryElement.attributeValue("name"), checkElement.attributeValue("name"));
                for (Element propertyElement : checkElement.elements("property")) {
                    sourceCheckConfiguration.addAttribute(propertyElement.attributeValue("name"), propertyElement.attributeValue("value"));
                }
                Element weightElement = checkElement.element("weight");
                if (weightElement != null) {
                    sourceCheckConfiguration.setWeight(GetterUtil.getInteger(weightElement.getText()));
                }
                sourceFormatterConfiguration.addSourceCheckConfiguration(sourceProcessorName, sourceCheckConfiguration);
            }
        }
        return sourceFormatterConfiguration;
    }
}

