/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.util.GradleBuildFileVisitor;
import com.liferay.source.formatter.util.GradleDependency;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;

public class GradleBuildFile {
    private static final Log _log = LogFactoryUtil.getLog(GradleBuildFile.class);
    private String _source;

    public GradleBuildFile(String source) {
        this._source = source;
    }

    public void deleteGradleDependencies(List<GradleDependency> gradleDependencies) {
        List<String> sourceLines = this.getSourceLines();
        gradleDependencies.sort(GradleDependency.COMPARATOR_LAST_LINE_NUMBER_DESC);
        for (GradleDependency gradleDependency : gradleDependencies) {
            int lastLineNumber;
            int lineNumber = gradleDependency.getLineNumber();
            for (int i = lastLineNumber = gradleDependency.getLastLineNumber(); i >= lineNumber; --i) {
                sourceLines.remove(i - 1);
            }
        }
        this._saveSource(sourceLines);
    }

    public void deleteGradleDependency(String group, String name) {
        this.deleteGradleDependency(null, group, name);
    }

    public void deleteGradleDependency(String configuration, String group, String name) {
        List<String> sourceLines = this.getSourceLines();
        List<GradleDependency> gradleDependencies = this.getGradleDependencies();
        ListIterator<GradleDependency> listIterator = gradleDependencies.listIterator(gradleDependencies.size());
        while (listIterator.hasPrevious()) {
            GradleDependency gradleDependency = listIterator.previous();
            if (configuration != null && !Objects.equals(configuration, gradleDependency.getConfiguration()) || !Objects.equals(group, gradleDependency.getGroup()) || !Objects.equals(name, gradleDependency.getName())) continue;
            for (int i = gradleDependency.getLastLineNumber(); i >= gradleDependency.getLineNumber(); --i) {
                sourceLines.remove(i - 1);
            }
        }
        this._saveSource(sourceLines);
    }

    public List<GradleDependency> getBuildScriptDependencies() {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        return gradleBuildFileVisitor.getBuildScriptDependencies();
    }

    public List<GradleDependency> getBuildScriptDependencies(String configuration) {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        return ListUtil.filter(gradleBuildFileVisitor.getBuildScriptDependencies(), gradleDependency -> Objects.equals(configuration, gradleDependency.getConfiguration()));
    }

    public List<GradleDependency> getGradleDependencies() {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        return gradleBuildFileVisitor.getGradleDependencies();
    }

    public List<GradleDependency> getGradleDependencies(String configuration) {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        return ListUtil.filter(gradleBuildFileVisitor.getGradleDependencies(), gradleDependency -> Objects.equals(configuration, gradleDependency.getConfiguration()));
    }

    public String getSource() {
        return this._source;
    }

    public List<String> getSourceLines() {
        return ListUtil.fromString(this._source, "\n");
    }

    public void insertGradleDependency(GradleDependency gradleDependency) {
        GradleBuildFileVisitor gradleBuildFileVisitor = this._walkAST();
        for (GradleDependency currentGradleDependency : gradleBuildFileVisitor.getGradleDependencies()) {
            if (!currentGradleDependency.equals(gradleDependency)) continue;
            return;
        }
        List<String> sourceLines = this.getSourceLines();
        int dependenciesLastLineNumber = gradleBuildFileVisitor.getDependenciesLastLineNumber();
        if (dependenciesLastLineNumber == -1) {
            sourceLines.add("");
            sourceLines.add("dependencies {");
            sourceLines.add("\t" + gradleDependency.toString());
            sourceLines.add("}");
        } else {
            sourceLines.add(dependenciesLastLineNumber - 1, "\t" + gradleDependency.toString());
        }
        this._saveSource(sourceLines);
    }

    public void insertGradleDependency(String configuration, String group, String name) {
        this.insertGradleDependency(configuration, group, name, null);
    }

    public void insertGradleDependency(String configuration, String group, String name, String version) {
        this.insertGradleDependency(new GradleDependency(configuration, group, name, version));
    }

    private void _saveSource(List<String> lines) {
        this._source = StringUtil.merge(lines, "\n");
    }

    private GradleBuildFileVisitor _walkAST() {
        GradleBuildFileVisitor gradleBuildFileVisitor;
        block4: {
            gradleBuildFileVisitor = new GradleBuildFileVisitor();
            if (Validator.isNull(this._source)) {
                return gradleBuildFileVisitor;
            }
            AstBuilder astBuilder = new AstBuilder();
            try {
                for (ASTNode astNode : astBuilder.buildFromString(CompilePhase.CONVERSION, this._source)) {
                    if (astNode instanceof ClassNode) continue;
                    astNode.visit(gradleBuildFileVisitor);
                }
            }
            catch (CompilationFailedException compilationFailedException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(compilationFailedException);
            }
        }
        return gradleBuildFileVisitor;
    }
}

