/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleProvidedDependenciesCheck
extends BaseFileCheck {
    private static final Pattern _blocksPattern = Pattern.compile("^(configurations|dependencies)\\s*(\\{\\s*\\}|\\{.*?\\n\\})", 40);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("/build.gradle")) {
            return content;
        }
        String scope = this._getScope(content);
        for (String block : this._getBlocks(content)) {
            content = this._format(content, block, scope);
        }
        return StringUtil.replace(content, new String[]{"configurations.provided", "extendsFrom provided"}, new String[]{"configurations." + scope, "extendsFrom " + scope});
    }

    private String _format(String content, String dependencies, String scope) {
        String newDependencies = dependencies.replaceAll("\\bprovided\\b", scope);
        return StringUtil.replace(content, dependencies, newDependencies);
    }

    private List<String> _getBlocks(String content) {
        ArrayList<String> blocks = new ArrayList<String>();
        Matcher matcher = _blocksPattern.matcher(content);
        while (matcher.find()) {
            blocks.add(matcher.group());
        }
        return blocks;
    }

    private String _getScope(String content) {
        if (GradleSourceUtil.isSpringBootExecutable(content)) {
            return "compile";
        }
        return "compileOnly";
    }
}

