/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MappingEnumeration<T, R>
implements Enumeration<R> {
    protected final Enumeration<T> enumeration;
    protected final Mapper<T, R> mapper;
    protected R nextElement;

    public MappingEnumeration(Enumeration<T> enumeration, Mapper<T, R> mapper) {
        this.enumeration = enumeration;
        this.mapper = mapper;
        this.nextElement = this.nextMappedElement();
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextElement != null;
    }

    @Override
    public R nextElement() {
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        R nextElement = this.nextElement;
        this.nextElement = this.nextMappedElement();
        return nextElement;
    }

    protected final R nextMappedElement() {
        while (this.enumeration.hasMoreElements()) {
            R element = this.mapper.map(this.enumeration.nextElement());
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static interface Mapper<T, R> {
        public R map(T var1);
    }
}

