/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceUpdateCheck
extends BaseCheck {
    private static final String _MSG_REASSIGN_UPDATE_CALL = "update.call.reassign";
    private static final Pattern _serviceUpdatePattern = Pattern.compile("_?(\\w+?)(Local)?Service(Util)?\\.update([A-Z]\\w+)");

    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        Matcher matcher = _serviceUpdatePattern.matcher(fullIdent.getText());
        if (!matcher.matches() || !StringUtil.equalsIgnoreCase(matcher.group(1), matcher.group(4))) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST slistDetailAST = parentDetailAST.getParent();
        if (slistDetailAST.getType() != 7) {
            return;
        }
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() == 0) {
            return;
        }
        firstChildDetailAST = elistDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 28) {
            return;
        }
        DetailAST nameDetailAST = firstChildDetailAST.getFirstChild();
        if (nameDetailAST.getType() != 58) {
            return;
        }
        String variableName = nameDetailAST.getText();
        DetailAST typeDetailAST = this.getVariableTypeDetailAST(detailAST, variableName);
        if (typeDetailAST == null || !StringUtil.equalsIgnoreCase(matcher.group(1), this.getTypeName(typeDetailAST, false))) {
            return;
        }
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(typeDetailAST.getParent(), variableName);
        int size = variableCallerDetailASTList.size();
        for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
            if (!this.hasParentWithTokenType(variableCallerDetailAST, 181)) continue;
            return;
        }
        for (int i = 0; i < size; ++i) {
            DetailAST secondNextVariableCallerDetailAST;
            if (!this.equals(variableCallerDetailASTList.get(i), nameDetailAST)) continue;
            if (i == size - 1) {
                return;
            }
            DetailAST firstNextVariableCallerDetailAST = variableCallerDetailASTList.get(i + 1);
            if (firstNextVariableCallerDetailAST.getPreviousSibling() != null || (parentDetailAST = firstNextVariableCallerDetailAST.getParent()).getType() != 80 || (parentDetailAST = parentDetailAST.getParent()).getType() != 28 || !this.equals(parentDetailAST.getParent(), slistDetailAST) || i > size - 2 || (secondNextVariableCallerDetailAST = variableCallerDetailASTList.get(i + 2)).getLineNo() <= this.getEndLineNumber(parentDetailAST)) break;
            return;
        }
        this.log(detailAST, _MSG_REASSIGN_UPDATE_CALL, new Object[]{variableName});
    }
}

