/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class UnusedParameterCheck
extends BaseCheck {
    private static final String _MSG_UNUSED_PARAMETER = "parameter.unused";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<DetailAST> constructorsAndMethodsASTList = this.getAllChildTokens(detailAST, true, 8, 9);
        for (DetailAST constructorOrMethodDetailAST : constructorsAndMethodsASTList) {
            this._checkUnusedParameters(detailAST, constructorOrMethodDetailAST);
        }
    }

    private void _checkUnusedParameters(DetailAST classDetailAST, DetailAST constructorOrMethodDetailAST) {
        DetailAST modifiersDetailAST = constructorOrMethodDetailAST.findFirstToken(5);
        if (!modifiersDetailAST.branchContains(61)) {
            return;
        }
        String constructorOrMethodName = this.getName(constructorOrMethodDetailAST);
        if (constructorOrMethodName.equals("readObject") || constructorOrMethodName.equals("writeObject")) {
            return;
        }
        List<String> parameterNames = this.getParameterNames(constructorOrMethodDetailAST);
        if (parameterNames.isEmpty()) {
            return;
        }
        DetailAST statementsDetailAST = constructorOrMethodDetailAST.findFirstToken(7);
        List<String> names = this.getNames(statementsDetailAST, true);
        for (String parameterName : this.getParameterNames(constructorOrMethodDetailAST)) {
            if (names.contains(parameterName) || this._isReferencedMethod(classDetailAST, constructorOrMethodDetailAST)) continue;
            this.log(constructorOrMethodDetailAST, _MSG_UNUSED_PARAMETER, new Object[]{parameterName});
        }
    }

    private boolean _isReferencedMethod(DetailAST classDetailAST, DetailAST constructorOrMethodDetailAST) {
        List<DetailAST> methodReferenceDetailASTList = this.getAllChildTokens(classDetailAST, true, 180);
        if (methodReferenceDetailASTList.isEmpty()) {
            return false;
        }
        String constructorOrMethodName = this.getName(constructorOrMethodDetailAST);
        for (DetailAST methodReferenceDetailAST : methodReferenceDetailASTList) {
            for (String name : this.getNames(methodReferenceDetailAST, true)) {
                if (!constructorOrMethodName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

