/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiPropsUtilCheck
extends BaseFileCheck {
    private static final Pattern _propsUtilGetPasswordPattern = Pattern.compile("\n\t+var (\\w+) = (PropsUtil.get\\(\"default.admin.password\"\\));");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith(".macro") && !fileName.endsWith(".testcase") || SourceUtil.isXML(content)) {
            return content;
        }
        File file = new File(this.getPortalDir(), "test.properties");
        if (!file.exists()) {
            return content;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return this._checkInlinePassword(fileName, content, properties);
    }

    private String _checkInlinePassword(String fileName, String content, Properties properties) {
        Matcher matcher = _propsUtilGetPasswordPattern.matcher(content);
        while (matcher.find()) {
            String variableName;
            String followingCode;
            String s;
            int x;
            String previousCodeBlock = content.substring(0, matcher.start());
            if (!previousCodeBlock.contains("\tmacro ") && !previousCodeBlock.contains("\ttest ") || (x = previousCodeBlock.lastIndexOf("if (")) != -1 && !(s = previousCodeBlock.substring(x)).contains("\tmacro ") && !s.contains("\ttest ") && this.getLevel(s, "{", "}") == 1 || !this._isUnnecessaryAssign(followingCode = this._getFollowingCode(content, matcher.end()), variableName = matcher.group(1))) continue;
            this.addMessage(fileName, StringBundler.concat("Pass \"", matcher.group(2), "\" directly instead of assigning value to variable \"", variableName, "\""), this.getLineNumber(content, matcher.start()) + 1);
        }
        String password = properties.getProperty("test.portal.default.admin.password");
        if (Validator.isNull(password)) {
            return content;
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("(\\w*[Pp]assword = )\"" + password + "\"");
        matcher = pattern.matcher(content);
        while (matcher.find()) {
            if (this._isInsideTripleQuotes(content, matcher.start())) continue;
            matcher.appendReplacement(sb, matcher.group(1) + "PropsUtil.get(\"default.admin.password\")");
        }
        if (sb.length() > 0) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    private String _getFollowingCode(String content, int end) {
        int x = content.indexOf("\n\t}", end);
        return content.substring(end, x);
    }

    private boolean _isInsideTripleQuotes(String content, int pos) {
        String s = content.substring(pos);
        int x = s.indexOf("''';");
        if (x == -1) {
            return false;
        }
        return !(s = s.substring(0, x)).contains("= '''");
    }

    private boolean _isUnnecessaryAssign(String content, String variableName) {
        String line;
        int x = -1;
        do {
            if ((x = content.indexOf("${" + variableName + "}", x + 1)) == -1) {
                return true;
            }
            if (!this._isInsideTripleQuotes(content, x)) continue;
            return false;
        } while (!(line = this.getLine(content, this.getLineNumber(content, x))).contains("curl") && !line.contains("if ("));
        return false;
    }
}

