/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ReturnVariableDeclarationAsUsedCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_DEFINITION = "empty.line.missing.after.variable.definition";
    private static final String _MSG_MOVE_VARIABLE_DECLARATION = "variable.declaration.move";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 9);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            DetailAST returnVariableDefinitionDetailAST;
            DetailAST returnIdentDetailAST;
            DetailAST slistDetailAST;
            String methodName;
            DetailAST typeDetailAST;
            String returnTypeName;
            DetailAST modifiersDetailAST = methodDefinitionDetailAST.findFirstToken(5);
            if (modifiersDetailAST.branchContains(40) || (returnTypeName = this.getTypeName(typeDetailAST = methodDefinitionDetailAST.findFirstToken(13), false)).equals("void") || !(methodName = this.getName(methodDefinitionDetailAST)).matches("_?(create|fetch|generate|get)[A-Z].+") || (slistDetailAST = methodDefinitionDetailAST.findFirstToken(7)) == null || (returnIdentDetailAST = this._getReturnIdentDetailAST(slistDetailAST)) == null) continue;
            String variableName = returnIdentDetailAST.getText();
            if (!StringUtil.equalsIgnoreCase(methodName.replaceFirst("_?(create|fetch|generate|get)(.+)", "$2"), variableName) || (returnVariableDefinitionDetailAST = this.getVariableDefinitionDetailAST(returnIdentDetailAST, variableName, false)) == null || returnVariableDefinitionDetailAST.getType() == 21) continue;
            DetailAST firstChildDetailAST = slistDetailAST.getFirstChild();
            if (this.equals(firstChildDetailAST, returnVariableDefinitionDetailAST)) {
                DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
                if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
                    return;
                }
                if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                    return;
                }
                int startLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
                int endLineNumber = this.getEndLineNumber(firstChildDetailAST);
                if (endLineNumber + 1 == startLineNumber) {
                    this.log(startLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_DEFINITION, new Object[]{startLineNumber});
                }
                return;
            }
            this._checkMoveVariableDeclaration(returnVariableDefinitionDetailAST, slistDetailAST, variableName);
        }
    }

    private void _checkMoveVariableDeclaration(DetailAST returnVariableDefinitionDetailAST, DetailAST slistDetailAST, String variableName) {
        if (this._containsMethodCalls(slistDetailAST, returnVariableDefinitionDetailAST.getLineNo()) || this._containsSynchronizedBlocks(slistDetailAST, returnVariableDefinitionDetailAST.getLineNo()) || this._containsUnusedVariableNames(slistDetailAST, returnVariableDefinitionDetailAST.getLineNo())) {
            return;
        }
        List<DetailAST> childDetailASTList = this.getAllChildTokens(slistDetailAST, true, 88, 90);
        for (DetailAST childDetailAST : childDetailASTList) {
            if (childDetailAST.getLineNo() >= returnVariableDefinitionDetailAST.getLineNo()) continue;
            return;
        }
        DetailAST returnVariableDefinitionAssignDetailAST = returnVariableDefinitionDetailAST.findFirstToken(80);
        if (returnVariableDefinitionAssignDetailAST == null) {
            this.log(returnVariableDefinitionDetailAST, _MSG_MOVE_VARIABLE_DECLARATION, new Object[]{variableName, this.getStartLineNumber(slistDetailAST.getFirstChild())});
            return;
        }
        DetailAST firstChildDetailAST = returnVariableDefinitionAssignDetailAST.getFirstChild();
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 135 || firstChildDetailAST.getType() == 142 || firstChildDetailAST.getType() == 140 || firstChildDetailAST.getType() == 137 || firstChildDetailAST.getType() == 141 || firstChildDetailAST.getType() == 139) {
            this.log(returnVariableDefinitionDetailAST, _MSG_MOVE_VARIABLE_DECLARATION, new Object[]{variableName, this.getStartLineNumber(slistDetailAST.getFirstChild())});
            return;
        }
        if (firstChildDetailAST.getType() == 27) {
            String methodName;
            DetailAST dotDetailAST = firstChildDetailAST.findFirstToken(59);
            if (dotDetailAST == null) {
                return;
            }
            List<String> names = this.getNames(dotDetailAST, false);
            if (names.size() != 2) {
                return;
            }
            if (StringUtil.equals(names.get(0), "Collections") && ((methodName = names.get(1)).equals("emptyList") || methodName.equals("emptyMap") || methodName.equals("emptySet"))) {
                this.log(returnVariableDefinitionDetailAST, _MSG_MOVE_VARIABLE_DECLARATION, new Object[]{variableName, this.getStartLineNumber(slistDetailAST.getFirstChild())});
                return;
            }
        }
        if (firstChildDetailAST.getType() != 136) {
            return;
        }
        DetailAST elistDetailAST = firstChildDetailAST.findFirstToken(34);
        if (elistDetailAST == null || elistDetailAST.getChildCount() != 0) {
            return;
        }
        DetailAST objBlockDetailAST = firstChildDetailAST.findFirstToken(6);
        if (objBlockDetailAST != null) {
            return;
        }
        this.log(returnVariableDefinitionDetailAST, _MSG_MOVE_VARIABLE_DECLARATION, new Object[]{variableName, this.getStartLineNumber(slistDetailAST.getFirstChild())});
    }

    private boolean _containsMethodCalls(DetailAST slistDetailAST, int lineNumber) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(slistDetailAST, true, 27);
        return !(methodCallDetailASTList = ListUtil.filter(methodCallDetailASTList, methodCallDetailAST -> {
            if (methodCallDetailAST.getLineNo() > lineNumber) {
                return false;
            }
            DetailAST parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() != 28) {
                return false;
            }
            if ((parentDetailAST = parentDetailAST.getParent()).getType() != 7) {
                return false;
            }
            String variableName = this.getVariableName((DetailAST)methodCallDetailAST);
            if (variableName == null) {
                return true;
            }
            if (Character.isUpperCase(variableName.charAt(0))) {
                return false;
            }
            DetailAST typeDetailAST = this.getVariableTypeDetailAST((DetailAST)methodCallDetailAST, variableName, false);
            return typeDetailAST == null;
        })).isEmpty();
    }

    private boolean _containsSynchronizedBlocks(DetailAST slistDetailAST, int lineNumber) {
        List<DetailAST> literalSynchronizedDetailASTList = this.getAllChildTokens(slistDetailAST, false, 67);
        if (literalSynchronizedDetailASTList.isEmpty()) {
            return false;
        }
        DetailAST literalSynchronizedDetailAST = literalSynchronizedDetailASTList.get(0);
        return literalSynchronizedDetailAST.getLineNo() < lineNumber;
    }

    private boolean _containsUnusedVariableNames(DetailAST slistDetailAST, int lineNumber) {
        List<DetailAST> assignDetailASTList = this.getAllChildTokens(slistDetailAST, true, 80);
        if ((assignDetailASTList = ListUtil.filter(assignDetailASTList, assignDetailAST -> {
            if (assignDetailAST.getLineNo() > lineNumber) {
                return false;
            }
            DetailAST parentDetailAST = assignDetailAST.getParent();
            return parentDetailAST.getType() == 28;
        })).isEmpty()) {
            return false;
        }
        List<DetailAST> identDetailASTList = this.getAllChildTokens(slistDetailAST, true, 58);
        block0: for (DetailAST assignDetailAST2 : assignDetailASTList) {
            DetailAST nameDetailAST = assignDetailAST2.getFirstChild();
            if (nameDetailAST.getType() != 58) continue;
            for (DetailAST identDetailAST : identDetailASTList) {
                if (this.equals(nameDetailAST, identDetailAST) || this.isMethodNameDetailAST(identDetailAST) || !StringUtil.equals(nameDetailAST.getText(), identDetailAST.getText())) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private DetailAST _getReturnIdentDetailAST(DetailAST detailAST) {
        DetailAST lastChildDetailAST = detailAST.getLastChild();
        DetailAST previousSiblingDetailAST = lastChildDetailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 88) {
            return null;
        }
        DetailAST firstChildDetailAST = previousSiblingDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 28) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) == null || firstChildDetailAST.getType() != 58) {
            return null;
        }
        return firstChildDetailAST;
    }
}

