/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiProperties;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.ReturnPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.script.PoshiScriptParserUtil;
import com.liferay.poshi.core.selenium.LiferaySeleniumMethod;
import com.liferay.poshi.core.util.ListUtil;
import com.liferay.poshi.core.util.NaturalOrderStringComparator;
import com.liferay.poshi.core.util.RegexUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class ExecutePoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "execute";
    private static final String _FUNCTION_PARAMETER_REGEX = "\".*\"|\\$\\{\\S+\\}|\\d*";
    private static final String _INVOCATION_REGEX = "[\\s]*[\\w\\.]*\\(.*?\\)(;|)";
    private static final String _UNQUOTED_PARAMETER_REGEX = "\\w*\\s*=\\s\"(\\$\\{[\\w_-]+\\}|\\d+)\"";
    private static final String _UTILITY_INVOCATION_REGEX = "(echo|fail|takeScreenshot|task[\\s]*)\\(.*?\\)";
    private static final Pattern _executeParameterPattern = Pattern.compile("^[\\s]*(\\w*\\s*=\\s*\"[ \\t\\S]*?\"|\\w*\\s*=\\s*'''.*?'''|\\w*\\s=\\s*[\\w\\.]*\\(.*?\\)|\\w*\\s*=\\s*\\d+|\\w*\\s*=\\s*\\$\\{\\S+\\})[\\s]*$", 32);
    private static final List<String> _functionAttributeNames = Arrays.asList("locator1", "locator2", "value1", "value2", "value3");
    private static final Pattern _functionParameterPattern = Pattern.compile("\".*\"|\\$\\{\\S+\\}|\\d*");
    private static final Pattern _partialStatementPattern = Pattern.compile("^" + INVOCATION_REGEX + "(;|)$", 32);
    private static final Pattern _statementPattern = Pattern.compile("^[\\s]*[\\w\\.]*\\(.*?\\)(;|)", 32);
    private static final Pattern _utilityInvocationStatementPattern = Pattern.compile("^(echo|fail|takeScreenshot|task[\\s]*)\\(.*?\\)");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new ExecutePoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new ExecutePoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        this.validateSemicolon(poshiScript);
        String poshiScriptParentheticalContent = this.getParentheticalContent(poshiScript);
        String fileExtension = this.getFileExtension();
        if (fileExtension.equals("function") && poshiScript.startsWith("selenium.")) {
            String commandName = this.getCommandName(poshiScript);
            this.addAttribute("selenium", commandName);
            LiferaySeleniumMethod liferaySeleniumMethod = PoshiContext.getLiferaySeleniumMethod(commandName);
            List<String> methodParameterValues = PoshiScriptParserUtil.getMethodParameterValues(poshiScriptParentheticalContent, this);
            PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
            if (liferaySeleniumMethod != null && liferaySeleniumMethod.getParameterCount() != methodParameterValues.size() && poshiProperties.generateCommandSignature.booleanValue()) {
                List<String> parameterNames = liferaySeleniumMethod.getParameterNames();
                for (int i = 0; i < parameterNames.size(); ++i) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("${");
                    sb.append(parameterNames.get(i));
                    sb.append("}");
                    this.addAttribute("argument" + (i + 1), sb.toString());
                }
            } else {
                for (int i = 0; i < methodParameterValues.size(); ++i) {
                    String methodParameterValue = methodParameterValues.get(i);
                    if (this.isQuotedContent(methodParameterValue)) {
                        methodParameterValue = this.getDoubleQuotedContent(methodParameterValue);
                    }
                    this.addAttribute("argument" + (i + 1), methodParameterValue);
                }
            }
            return;
        }
        String executeCommandName = RegexUtil.getGroup(poshiScript, "([^\\s]*?)\\(", 1);
        boolean namespacedCommandName = false;
        for (String namespace : PoshiContext.getNamespaces()) {
            if (!executeCommandName.startsWith(namespace + ".")) continue;
            namespacedCommandName = true;
            break;
        }
        if (namespacedCommandName) {
            String namespace;
            int index = executeCommandName.indexOf(".");
            namespace = executeCommandName.substring(0, index);
            executeCommandName = StringUtil.replaceFirst(executeCommandName, namespace + ".", "");
            executeCommandName = StringUtil.replace(executeCommandName, '.', '#');
            executeCommandName = namespace + "." + executeCommandName;
        } else {
            executeCommandName = StringUtil.replace(executeCommandName, '.', '#');
        }
        if (this.isValidFunctionFileName(poshiScript)) {
            this.addAttribute("function", executeCommandName);
        } else if (this.isValidMacroFileName(poshiScript)) {
            PoshiNode<?, ?> returnPoshiNode;
            this.addAttribute("macro", executeCommandName);
            if (poshiScript.startsWith("var ") && (returnPoshiNode = PoshiNodeFactory.newPoshiNode(this, poshiScript)) instanceof ReturnPoshiElement) {
                this.add(returnPoshiNode);
            }
        } else {
            this.addAttribute("class", this.getClassName(poshiScript));
            this.addAttribute("method", this.getCommandName(poshiScript));
            for (String methodParameterValue : PoshiScriptParserUtil.getMethodParameterValues(poshiScriptParentheticalContent, this)) {
                this.add(PoshiNodeFactory.newPoshiNode(this, methodParameterValue));
            }
            return;
        }
        for (String methodParameterValue : PoshiScriptParserUtil.getMethodParameterValues(poshiScriptParentheticalContent, _executeParameterPattern, this)) {
            methodParameterValue = methodParameterValue.trim();
            boolean functionAttributeAdded = false;
            for (String functionAttributeName : _functionAttributeNames) {
                String name = this.getNameFromAssignment(methodParameterValue);
                if (!name.equals(functionAttributeName)) continue;
                String value = this.getValueFromAssignment(methodParameterValue);
                Matcher matcher = _functionParameterPattern.matcher(value);
                if (!matcher.matches()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Invalid function parameter syntax, must ");
                    sb.append("match: (locator|value)(1|2) = \".*\"");
                    throw new PoshiScriptParserException(sb.toString(), methodParameterValue, (PoshiElement)this.getParent());
                }
                if (this.isQuotedContent(value)) {
                    value = this.getDoubleQuotedContent(value);
                    value = value.replace("\\\"", "\"");
                    value = StringEscapeUtils.unescapeXml((String)value);
                }
                this.add((Attribute)new PoshiElementAttribute(name, value, methodParameterValue));
                functionAttributeAdded = true;
                break;
            }
            if (functionAttributeAdded) continue;
            this.add(PoshiNodeFactory.newPoshiNode(this, methodParameterValue));
        }
    }

    @Override
    public String toPoshiScript() {
        ArrayList<String> assignments = new ArrayList<String>();
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributes())) {
            String poshiElementAttributeName = poshiElementAttribute.getName();
            if (poshiElementAttributeName.equals("class") || poshiElementAttributeName.equals("function") || poshiElementAttributeName.equals("macro") || poshiElementAttributeName.equals("method") || poshiElementAttributeName.equals("selenium")) continue;
            String fileExtension = this.getFileExtension();
            if (fileExtension.equals("function") && Validator.isNotNull(this.attributeValue("selenium"))) {
                String poshiElementAttributeValue = poshiElementAttribute.getValue();
                if (this.isQuotedContent(poshiElementAttributeValue)) {
                    poshiElementAttributeValue = this.doubleQuoteContent(poshiElementAttributeValue);
                }
                assignments.add(poshiElementAttributeValue);
                continue;
            }
            String poshiScript = poshiElementAttribute.toPoshiScript();
            if (poshiScript.matches(_UNQUOTED_PARAMETER_REGEX)) {
                poshiScript = poshiScript.replace("\"", "");
            }
            assignments.add(poshiScript.trim());
        }
        ReturnPoshiElement returnPoshiElement = null;
        for (PoshiElement poshiElement : this.toPoshiElements(this.elements())) {
            if (poshiElement instanceof ReturnPoshiElement) {
                returnPoshiElement = (ReturnPoshiElement)poshiElement;
                continue;
            }
            String poshiScript = poshiElement.toPoshiScript();
            assignments.add(poshiScript.trim());
        }
        String string = this.createPoshiScriptSnippet(assignments);
        if (returnPoshiElement == null) {
            return string;
        }
        return returnPoshiElement.createPoshiScriptSnippet(string);
    }

    protected ExecutePoshiElement() {
        this(_ELEMENT_NAME);
    }

    protected ExecutePoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected ExecutePoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this(_ELEMENT_NAME, attributes, nodes);
    }

    protected ExecutePoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    protected ExecutePoshiElement(String name) {
        super(name);
    }

    protected ExecutePoshiElement(String name, Element element) {
        super(name, element);
    }

    protected ExecutePoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected ExecutePoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    protected String createPoshiScriptSnippet(List<String> assignments) {
        StringBuilder sb = new StringBuilder();
        String pad = this.getPad();
        sb.append("\n\n");
        sb.append(pad);
        sb.append(StringUtil.replace(this.getBlockName(), '#', '.'));
        sb.append("(");
        boolean multilineSnippet = false;
        String assignmentsString = ListUtil.toString(assignments);
        if (assignments.size() == 1 && assignmentsString.startsWith("table = '''") || assignments.size() > 1 && assignmentsString.matches("(?s)\\w+\\s*=.+") && !this.isConditionValidInParent((PoshiElement)this.getParent())) {
            multilineSnippet = true;
        }
        Collections.sort(assignments, new Comparator<String>(){

            @Override
            public int compare(String assignment1, String assignment2) {
                if (!assignment1.matches("\\w+ = .+") && !assignment2.matches("\\w+ = .+")) {
                    return 0;
                }
                String name1 = assignment1.substring(0, assignment1.indexOf(61));
                String name2 = assignment2.substring(0, assignment2.indexOf(61));
                NaturalOrderStringComparator naturalOrderStringComparator = new NaturalOrderStringComparator();
                return naturalOrderStringComparator.compare(name1, name2);
            }
        });
        for (String assignment : assignments) {
            String s = sb.toString();
            s = s.substring(s.lastIndexOf("\n"));
            if (multilineSnippet) {
                if (s.endsWith(" ")) {
                    sb.setLength(sb.length() - 1);
                }
                sb.append("\n\t");
                sb.append(pad);
            }
            sb.append(assignment);
            sb.append(", ");
        }
        if (!assignments.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    protected String getBlockName() {
        if (this.attributeValue("class") != null) {
            return this.attributeValue("class") + "." + this.attributeValue("method");
        }
        if (this.attributeValue("function") != null) {
            return this.attributeValue("function");
        }
        if (this.attributeValue("macro") != null) {
            return this.attributeValue("macro");
        }
        return "selenium." + this.attributeValue("selenium");
    }

    @Override
    protected Pattern getStatementPattern() {
        String poshiScript = this.getPoshiScript();
        if ((poshiScript = poshiScript.trim()).startsWith("var") && this.isVarAssignedToMacroInvocation(this.getPoshiScript())) {
            return varInvocationAssignmentStatementPattern;
        }
        return _statementPattern;
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (this.isConditionValidInParent(parentPoshiElement) || parentPoshiElement instanceof ExecutePoshiElement) {
            return false;
        }
        return (this.isVarAssignedToMacroInvocation(poshiScript) || this.isValidPoshiScriptStatement(_partialStatementPattern, poshiScript)) && !this.isValidPoshiScriptStatement(_utilityInvocationStatementPattern, poshiScript);
    }
}

