/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.IOException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLLookAndFeelCompatibilityVersionCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("-look-and-feel.xml")) {
            this._checkCompatibility(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkCompatibility(String fileName, String absolutePath, String content) throws IOException {
        if (!this.isPortalSource() || !this.isModulesApp(absolutePath, false)) {
            return;
        }
        boolean privateApp = this.isModulesApp(absolutePath, true);
        String portalVersion = this.getPortalVersion(privateApp);
        if (Validator.isNull(portalVersion)) {
            return;
        }
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        List compatibilityElements = rootElement.elements("compatibility");
        for (Element compatibilityElement : compatibilityElements) {
            if (this._hasPortalVersions(compatibilityElement, portalVersion)) continue;
            this.addMessage(fileName, StringBundler.concat("Missing version: <version>", portalVersion, "+</version>"));
        }
    }

    private boolean _hasPortalVersions(Element compatibilityElement, String portalVersion) {
        List versionElements = compatibilityElement.elements("version");
        for (Element versionElement : versionElements) {
            String version = versionElement.getText();
            if (!StringUtil.equalsIgnoreCase(version, portalVersion + "+")) continue;
            return true;
        }
        return false;
    }
}

