/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaGetLayoutDisplayPageProviderCheck
extends BaseUpgradeCheck {
    private static final Pattern _pattern = Pattern.compile("\\w+\\.\\s*getLayoutDisplayPageProvider\\s*\\(\\s*.+\\s*\\)\\;");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Matcher matcher = _pattern.matcher(javaMethodContent);
            while (matcher.find()) {
                if (!this.hasClassOrVariableName("LayoutDisplayPageProviderRegistry", javaMethodContent, content, fileName, matcher.group())) continue;
                String line = matcher.group();
                String newLine = StringUtil.replace(line, "getLayoutDisplayPageProvider", "getLayoutDisplayPageProviderByClassName");
                javaMethodContent = StringUtil.replace(javaMethodContent, line, newLine);
            }
            content = StringUtil.replace(content, javaMethod.getContent(), javaMethodContent);
        }
        return content;
    }
}

