/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaStorageTypeAwareCheck
extends BaseUpgradeCheck {
    private static final Pattern _deprecatedInterfacePattern = Pattern.compile("implements[\\w\\s,]*,?\\s*StorageTypeAware,?");
    private static final Pattern _overridePattern = Pattern.compile("(\\t*@Override\\n+)\\s*\\w*\\s*StorageType");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        String newContent = content;
        Matcher deprecatedInterfaceMatcher = _deprecatedInterfacePattern.matcher(content);
        if (deprecatedInterfaceMatcher.find()) {
            String deprecatedInterface = deprecatedInterfaceMatcher.group();
            newContent = deprecatedInterface.contains(", StorageTypeAware") ? StringUtil.removeSubstring(newContent, ", StorageTypeAware") : (deprecatedInterface.contains("StorageTypeAware,") ? StringUtil.removeSubstring(newContent, "StorageTypeAware,") : StringUtil.removeSubstring(newContent, deprecatedInterface));
            Matcher overrideMatcher = _overridePattern.matcher(content);
            if (overrideMatcher.find()) {
                newContent = StringUtil.removeSubstring(newContent, overrideMatcher.group(1));
            }
            newContent = StringUtil.removeSubstring(newContent, "import com.liferay.portal.kernel.scheduler.StorageTypeAware;\n");
        }
        return newContent;
    }
}

