/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeConnectionCheck
extends BaseJavaTermCheck {
    private static final String[] _SKIP_DIR_NAMES = new String[]{"/sdk/", "/sql/", "/test/", "/test-classes/", "/test-coverage/", "/test-results/", "/tmp/"};
    private static final Pattern _extendedClassPattern = Pattern.compile("\\sextends\\s+([\\w\\.]+)\\W");
    private List<String> _upgradeAbsolutePaths;
    private final Map<String, String> _upgradeContentsMap = new HashMap<String, String>();

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (absolutePath.contains("/test/")) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        String className = javaClass.getName();
        if ((className.contains("Upgrade") || className.contains("Verify")) && this._extendsPortalKernelUpgradeProcess(absolutePath, fileContent)) {
            this._checkDataAccessGetConnection(fileName, fileContent, javaClass);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkDataAccessGetConnection(String fileName, String fileContent, JavaClass javaClass) {
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            String methodContent;
            int x;
            JavaMethod javaMethod;
            String methodName;
            if (!childJavaTerm.isJavaMethod() || (methodName = (javaMethod = (JavaMethod)childJavaTerm).getName()).equals("upgrade") && javaMethod.hasAnnotation("Override") || (x = (methodContent = javaMethod.getContent()).indexOf("DataAccess.getConnection")) == -1) continue;
            this.addMessage(fileName, "Use existing connection field instead of DataAccess.getConnection", this.getLineNumber(fileContent, x));
        }
    }

    private boolean _extendsPortalKernelUpgradeProcess(String absolutePath, String fileContent) throws IOException {
        String upgradeAbsolutePath = absolutePath;
        String upgradeContent = fileContent;
        while (Validator.isNotNull(upgradeAbsolutePath)) {
            if (!absolutePath.equals(upgradeAbsolutePath)) {
                upgradeContent = this._getUpgradeContent(upgradeAbsolutePath);
            }
            upgradeAbsolutePath = "";
            if (Validator.isNull(upgradeContent)) {
                return false;
            }
            Matcher matcher = _extendedClassPattern.matcher(upgradeContent);
            if (matcher.find()) {
                String extendedClassName = matcher.group(1);
                String relativePath = "";
                if (extendedClassName.contains(".")) {
                    relativePath = StringUtil.replace(extendedClassName, '.', '/');
                } else {
                    String fullyQualifiedName = "";
                    List<String> importNames = JavaSourceUtil.getImportNames(upgradeContent);
                    for (String importName : importNames) {
                        if (!importName.endsWith('.' + extendedClassName)) continue;
                        fullyQualifiedName = importName;
                        break;
                    }
                    if (Validator.isNotNull(fullyQualifiedName)) {
                        relativePath = StringUtil.replace(fullyQualifiedName, '.', '/');
                    } else {
                        String fileLocation = absolutePath.substring(0, absolutePath.lastIndexOf(47) + 1);
                        relativePath = fileLocation + extendedClassName;
                    }
                }
                for (String s : this._getUpgradeAbsolutePaths()) {
                    if (!s.endsWith(relativePath + ".java")) continue;
                    upgradeAbsolutePath = s;
                    break;
                }
            }
            if (!upgradeAbsolutePath.endsWith("com/liferay/portal/kernel/upgrade/UpgradeProcess.java")) continue;
            return true;
        }
        return false;
    }

    private synchronized List<String> _getUpgradeAbsolutePaths() throws IOException {
        if (this._upgradeAbsolutePaths != null) {
            return this._upgradeAbsolutePaths;
        }
        File portalDir = this.getPortalDir();
        if (portalDir == null) {
            this._upgradeAbsolutePaths = Collections.emptyList();
            return this._upgradeAbsolutePaths;
        }
        ArrayList<String> upgradeAbsolutePaths = new ArrayList<String>();
        List<String> fileNames = SourceFormatterUtil.scanForFileNames(portalDir.getCanonicalPath(), new String[]{"**/upgrade/**/*.java"});
        block0: for (String fileName : fileNames) {
            for (String skipDirName : _SKIP_DIR_NAMES) {
                if (fileName.contains(skipDirName)) continue block0;
            }
            upgradeAbsolutePaths.add(fileName);
        }
        this._upgradeAbsolutePaths = upgradeAbsolutePaths;
        return this._upgradeAbsolutePaths;
    }

    private synchronized String _getUpgradeContent(String absolutePath) throws IOException {
        if (this._upgradeContentsMap.containsKey(absolutePath)) {
            return this._upgradeContentsMap.get(absolutePath);
        }
        File file = new File(absolutePath);
        if (!file.exists()) {
            return "";
        }
        this._upgradeContentsMap.put(absolutePath, FileUtil.read(file));
        return this._upgradeContentsMap.get(absolutePath);
    }
}

