/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseAddComponentAnnotationCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.dom4j.Document;
import org.dom4j.Element;

public class UpgradeJavaServiceImplCheck
extends BaseAddComponentAnnotationCheck {
    @Override
    protected String getAnnotationContent(String absolutePath, String className, String content, JavaClass javaClass) {
        return this.joinLines("@Component(", "\tproperty = {", String.format("\t\t\"json.web.service.context.name=%s\",", this._getContextName(javaClass, absolutePath)), String.format("\t\t\"json.web.service.context.path=%s\"", this._getContextPath(className)), "\t},", "\tservice = AopService.class", ")");
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.portal.aop.AopService", "org.osgi.service.component.annotations.Component"};
    }

    @Override
    protected boolean isValidClassName(String className) {
        if (className.contains("LocalServiceBaseImpl")) {
            return false;
        }
        return className.contains("ServiceBaseImpl");
    }

    private String _getContextName(JavaClass javaClass, String absolutePath) {
        File serviceXMLFile = this._getServiceXML(absolutePath);
        if (serviceXMLFile != null) {
            Document document = SourceUtil.readXML(FileUtil.read(serviceXMLFile));
            return StringUtil.toLowerCase(this._getPortletShortName(document.getRootElement()));
        }
        String contextName = StringUtil.extractFirst(javaClass.getPackageName(), ".service.impl");
        return StringUtil.extractLast(contextName, ".");
    }

    private String _getContextPath(String baseImplName) {
        return StringUtil.extractFirst(baseImplName, "ServiceBaseImpl");
    }

    private String _getPortletShortName(Element rootElement) {
        Element portletElement = rootElement.element("portlet");
        if (portletElement != null) {
            return portletElement.attributeValue("short-name");
        }
        Element namespaceElement = rootElement.element("namespace");
        return namespaceElement.getText();
    }

    private File _getServiceXML(String absolutePath) {
        Path serviceXmlPath = Paths.get(absolutePath, new String[0]);
        while (!(serviceXmlPath = serviceXmlPath.getParent()).endsWith("src")) {
        }
        serviceXmlPath = serviceXmlPath.getParent();
        File file = (serviceXmlPath = serviceXmlPath.resolve("service.xml")).toFile();
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

