/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;

public class JavaIgnoreAnnotationCheck
extends BaseJavaTermCheck {
    private static final String _CLASS_NAMES_BLACKLIST_KEY = "classNamesBlacklist";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass;
        if (!javaTerm.hasAnnotation("Ignore") || !javaTerm.hasAnnotation("Test")) {
            return javaTerm.getContent();
        }
        List<String> classNames = this.getAttributeValues(_CLASS_NAMES_BLACKLIST_KEY, absolutePath);
        if (classNames.contains((javaClass = javaTerm.getParentJavaClass()).getName(true))) {
            this.addMessage(fileName, "Do not ignore test in \"" + javaClass.getName() + "\"", javaTerm.getLineNumber());
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }
}

