/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.OrderByComparator;

public class RoleDescriptionComparator
extends OrderByComparator<Role> {
    public static final String ORDER_BY_ASC = "Role_.description ASC, Role_.name ASC";
    public static final String ORDER_BY_DESC = "Role_.description DESC, Role_.name DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"description", "name"};
    private static final RoleDescriptionComparator _INSTANCE_ASCENDING = new RoleDescriptionComparator(true);
    private static final RoleDescriptionComparator _INSTANCE_DESCENDING = new RoleDescriptionComparator(false);
    private final boolean _ascending;

    public static RoleDescriptionComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    @Override
    public int compare(Role role1, Role role2) {
        String description2;
        String description1 = role1.getDescription();
        int value = description1.compareTo(description2 = role2.getDescription());
        if (value == 0) {
            String name1 = role1.getName();
            String name2 = role2.getName();
            value = name1.compareTo(name2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    private RoleDescriptionComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

