/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModifiedServiceMethodCheck
extends BaseJavaTermCheck {
    private static final Pattern _missingEmptyLinePattern = Pattern.compile("\tremovedService\\([^;]+;(\n)\t+addingService\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent = javaTerm.getContent();
        String methodName = javaTerm.getName();
        if (!methodName.equals("modifiedService")) {
            return javaTermContent;
        }
        Matcher matcher = _missingEmptyLinePattern.matcher(javaTermContent);
        if (matcher.find()) {
            return StringUtil.replaceFirst(javaTermContent, "\n", "\n\n", matcher.start(1));
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }
}

