/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaProductDTOConverterReferenceCheck
extends BaseUpgradeCheck {
    private static final Pattern _pattern = Pattern.compile("@Reference\\s*(private|public|protected) ProductDTOConverter (.*?);");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            Matcher matcher;
            String childJavaTermContent = childJavaTerm.getContent();
            if (!childJavaTerm.hasAnnotation("Reference") || !childJavaTermContent.contains("ProductDTOConverter") || !(matcher = _pattern.matcher(content)).find()) continue;
            return matcher.replaceFirst(this._getAnnotationContent(matcher.group(2)));
        }
        return content;
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.commerce.product.model.CPDefinition", "com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product", "com.liferay.portal.vulcan.dto.converter.DTOConverter"};
    }

    private String _getAnnotationContent(String variableName) {
        return this.joinLines("@Reference(", "\t\ttarget = \"(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.ProductDTOConverter)\"", "\t)", String.format("\tprivate DTOConverter<CPDefinition, Product> %s;", variableName));
    }
}

