/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.VariableNameCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ExceptionVariableNameCheck
extends VariableNameCheck {
    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 12, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        Map<String, Set<ExceptionDefinition>> exceptionDefinitionsMap = this._getExceptionDefinitionsMap(detailAST);
        for (Map.Entry<String, Set<ExceptionDefinition>> entry : exceptionDefinitionsMap.entrySet()) {
            String typeName = entry.getKey();
            Set<ExceptionDefinition> exceptionDefinitions = entry.getValue();
            for (ExceptionDefinition exceptionDefinition : exceptionDefinitions) {
                int counter = this._getCounter(exceptionDefinition, exceptionDefinitions);
                String name = exceptionDefinition.getName();
                String expectedName = this.getExpectedVariableName(typeName);
                if (counter != 0) {
                    expectedName = expectedName + String.valueOf(counter);
                }
                if (name.equals(expectedName)) continue;
                this.log(exceptionDefinition.getLineNumber(), "variable.rename", new Object[]{name, expectedName});
            }
        }
    }

    private int _getCounter(ExceptionDefinition exceptionDefinition, Set<ExceptionDefinition> exceptionDefinitionSet) {
        if (exceptionDefinitionSet.size() == 1) {
            return 0;
        }
        int precedingOverlappingExceptionCount = 0;
        for (ExceptionDefinition curExceptionDefinition : exceptionDefinitionSet) {
            if (exceptionDefinition.equals(curExceptionDefinition)) {
                if (precedingOverlappingExceptionCount <= 0) continue;
                return precedingOverlappingExceptionCount + 1;
            }
            if (curExceptionDefinition.compareTo(exceptionDefinition) < 0) {
                if (curExceptionDefinition.getEndRangeLineNumber() < exceptionDefinition.getLineNumber()) continue;
                ++precedingOverlappingExceptionCount;
                continue;
            }
            if (exceptionDefinition.getEndRangeLineNumber() < curExceptionDefinition.getLineNumber()) continue;
            return 1;
        }
        return 0;
    }

    private int _getEndRangeLineNumber(DetailAST detailAST) {
        DetailAST slistDetailAST = null;
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 7) {
            slistDetailAST = parentDetailAST;
        } else {
            if (parentDetailAST.getType() != 96) {
                parentDetailAST = parentDetailAST.getParent();
            }
            slistDetailAST = parentDetailAST.getLastChild();
        }
        if (slistDetailAST.getType() == 7) {
            DetailAST lastChildDetailAST = slistDetailAST.getLastChild();
            return lastChildDetailAST.getLineNo();
        }
        return this.getEndLineNumber(parentDetailAST);
    }

    private Map<String, Set<ExceptionDefinition>> _getExceptionDefinitionsMap(DetailAST detailAST) {
        HashMap<String, Set<ExceptionDefinition>> exceptionDefinitionsMap = new HashMap<String, Set<ExceptionDefinition>>();
        List<DetailAST> definitionDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 21, 10);
        for (DetailAST definitionDetailAST : definitionDetailASTList) {
            DetailAST ancestorDetailAST;
            String exceptionTypeName;
            DetailAST parentDetailAST = definitionDetailAST.getParent();
            if (parentDetailAST.getType() == 6 || (exceptionTypeName = this._getExceptionTypeName(definitionDetailAST)) == null || !this.equals(ancestorDetailAST = this.getParentWithTokenType(definitionDetailAST, 8, 9, 12, 10), detailAST)) continue;
            TreeSet<ExceptionDefinition> exceptionDefinitions = (TreeSet<ExceptionDefinition>)exceptionDefinitionsMap.get(exceptionTypeName);
            if (exceptionDefinitions == null) {
                exceptionDefinitions = new TreeSet<ExceptionDefinition>();
            }
            DetailAST nameDetailAST = definitionDetailAST.findFirstToken(58);
            exceptionDefinitions.add(new ExceptionDefinition(nameDetailAST.getText(), definitionDetailAST.getLineNo(), definitionDetailAST.getColumnNo(), this._getEndRangeLineNumber(definitionDetailAST)));
            exceptionDefinitionsMap.put(exceptionTypeName, exceptionDefinitions);
        }
        return exceptionDefinitionsMap;
    }

    private String _getExceptionTypeName(DetailAST definitionDetailAST) {
        DetailAST firstChildDetailAST;
        DetailAST typeDetailAST = definitionDetailAST.findFirstToken(13);
        DetailAST parentDetailAST = definitionDetailAST.getParent();
        if (parentDetailAST.getType() == 96 && (firstChildDetailAST = typeDetailAST.getFirstChild()) != null && firstChildDetailAST.getType() == 112) {
            for (String name : this.getNames(firstChildDetailAST, true)) {
                if (!name.endsWith("Exception")) continue;
                return "Exception";
            }
            return null;
        }
        String exceptionTypeName = this.getTypeName(typeDetailAST, false);
        String[] parts = StringUtil.split(exceptionTypeName, ".");
        if (exceptionTypeName.endsWith("Exception")) {
            return parts[parts.length - 1];
        }
        if (parentDetailAST.getType() != 96) {
            return null;
        }
        if (parentDetailAST.getType() == 96) {
            for (String part : parts) {
                if (!part.endsWith("Exception")) continue;
                return part;
            }
        }
        return null;
    }

    private class ExceptionDefinition
    implements Comparable<ExceptionDefinition> {
        private final int _endRangeLineNumber;
        private final int _lineNumber;
        private final int _linePosition;
        private final String _name;

        public ExceptionDefinition(String name, int lineNumber, int linePosition, int endRangeLineNumber) {
            this._name = name;
            this._lineNumber = lineNumber;
            this._linePosition = linePosition;
            this._endRangeLineNumber = endRangeLineNumber;
        }

        @Override
        public int compareTo(ExceptionDefinition exceptionDefinition) {
            if (this._lineNumber != exceptionDefinition.getLineNumber()) {
                return this._lineNumber - exceptionDefinition.getLineNumber();
            }
            return this._linePosition - exceptionDefinition.getLinePosition();
        }

        public int getEndRangeLineNumber() {
            return this._endRangeLineNumber;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public int getLinePosition() {
            return this._linePosition;
        }

        public String getName() {
            return this._name;
        }
    }
}

