/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _incorrectWhitesapcePattern = Pattern.compile("\\\\\":(?=\\\\)");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.contains("/portal-web/test/")) {
            return content;
        }
        Matcher matcher = _incorrectWhitesapcePattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.insert(content, " ", matcher.end());
        }
        return super.doProcess(fileName, absolutePath, content);
    }
}

