/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLWorkflowDefinitionFileStylingCheck
extends BaseFileCheck {
    private static final Pattern _labelTagPattern = Pattern.compile("\t<label [^>]*?>\n\t*(.+)\n\t*</label>");
    private static final Pattern _notificationTagPattern = Pattern.compile("(\\t+)<notification>[\\s\\S]+?</notification>");
    private static final Pattern _templateTagPattern = Pattern.compile("(\\t+)<template>([\\s\\S]+?)</template>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("workflow-definition.xml")) {
            return content;
        }
        content = this._formatLabelTags(content);
        content = this._formatNotificationTags(content);
        return this._formatTemplateTags(content);
    }

    private String _formatLabelTags(String content) {
        Matcher matcher = _labelTagPattern.matcher(content);
        while (matcher.find()) {
            String titleCaseLabel;
            String label = matcher.group(1);
            if (label.equals(titleCaseLabel = StringUtil.getTitleCase(label, false, new String[0]))) continue;
            return StringUtil.replaceFirst(content, label, titleCaseLabel, matcher.start(1));
        }
        return content;
    }

    private String _formatNotificationTags(String content) {
        Matcher matcher = _notificationTagPattern.matcher(content);
        while (matcher.find()) {
            String titleCaseName;
            String name;
            int y;
            String notification = matcher.group();
            int x = notification.indexOf(matcher.group(1) + "\t<name>");
            if (x == -1 || (y = notification.indexOf("</name>", x)) == -1 || (name = notification.substring(x + 10, y)).equals(titleCaseName = StringUtil.getTitleCase(name, false, new String[0]))) continue;
            return StringUtil.replaceFirst(content, name, titleCaseName, matcher.start());
        }
        return content;
    }

    private String _formatTemplateTags(String content) {
        Matcher matcher = _templateTagPattern.matcher(content);
        while (matcher.find()) {
            String template = matcher.group(2);
            String trimmedTemplate = template.trim();
            if (!trimmedTemplate.startsWith("<![CDATA[") && !trimmedTemplate.endsWith("]]>")) continue;
            String cdataValue = trimmedTemplate.substring(9, trimmedTemplate.length() - 3);
            if ((cdataValue = cdataValue.trim()).equals("")) {
                return content;
            }
            int x = cdataValue.indexOf("\n");
            if (x != -1) {
                return content;
            }
            String indent = matcher.group(1);
            String replacement = StringBundler.concat("\n", indent, "\t<![CDATA[", cdataValue.trim(), "]]>\n", indent);
            if (template.equals(replacement)) continue;
            return StringUtil.replaceFirst(content, template, replacement, matcher.start(2));
        }
        return content;
    }
}

