/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;

public class JavaModuleTestUtilCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!(fileName.endsWith("TestUtil.java") && this.isModulesFile(absolutePath) && absolutePath.contains("/src/testIntegration"))) {
            return content;
        }
        String packageName = JavaSourceUtil.getPackageName(content);
        if (!packageName.startsWith("com.liferay")) {
            return content;
        }
        if (!packageName.endsWith(".test.util")) {
            this.addMessage(fileName, "Name of class ending with \"TestUtil\" should be in package ending with \".test.util\"");
        }
        return content;
    }
}

