/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.string;

import com.liferay.petra.string.StringBundler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Function;

public class StringUtil {
    public static boolean equalsIgnoreCase(char c1, char c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 > '\u007f' || c2 > '\u007f') {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2) || Character.toUpperCase(c1) == Character.toUpperCase(c2);
        }
        if (c1 < 'A' || c1 > 'z' || c2 < 'A' || c2 > 'z') {
            return false;
        }
        int delta = c1 - c2;
        return delta == 32 || delta == -32;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.equalsIgnoreCase(s1.charAt(i), s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String merge(boolean[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static String merge(byte[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static String merge(char[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static <T> String merge(Collection<T> col, Function<T, String> toStringFunction, String delimiter) {
        if (col instanceof List && col instanceof RandomAccess) {
            return StringUtil.merge((List)((Object)((RandomAccess)((Object)((List)col)))), toStringFunction, delimiter);
        }
        if (col == null) {
            return null;
        }
        if (col.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * col.size());
        for (T t : col) {
            sb.append(toStringFunction.apply(t));
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static <T> String merge(Collection<T> col, String delimiter) {
        return StringUtil.merge(col, String::valueOf, delimiter);
    }

    public static String merge(double[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static String merge(float[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static String merge(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static <T, L extends List<T> & RandomAccess> String merge(L list, Function<T, String> toStringFunction, String delimiter) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * list.size());
        for (int i = 0; i < list.size(); ++i) {
            sb.append(toStringFunction.apply(list.get(i)));
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static <T, L extends List<T> & RandomAccess> String merge(L list, String delimiter) {
        return StringUtil.merge(list, String::valueOf, delimiter);
    }

    public static String merge(long[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static String merge(short[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return String.valueOf(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static String merge(String[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return array[0];
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static <T> String merge(T[] array, Function<T, String> toStringFunction, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return toStringFunction.apply(array[0]);
        }
        StringBundler sb = new StringBundler(2 * array.length);
        for (int i = 0; i < array.length; ++i) {
            sb.append(toStringFunction.apply(array[i]));
            sb.append(delimiter);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static <T> String merge(T[] array, String delimiter) {
        return StringUtil.merge(array, String::valueOf, delimiter);
    }

    public static String read(ClassLoader classLoader, String name) throws IOException {
        return StringUtil.read(classLoader, name, false);
    }

    public static String read(ClassLoader classLoader, String name, boolean all) throws IOException {
        if (all) {
            StringBundler sb = new StringBundler();
            Enumeration<URL> enumeration = classLoader.getResources(name);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    String s = StringUtil.read(inputStream);
                    if (s == null) continue;
                    sb.append(s);
                    sb.append("\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            String s = sb.toString();
            return s.trim();
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(name);){
            if (inputStream == null) {
                throw new IOException(StringBundler.concat("Unable to open resource ", name, " in class loader ", classLoader));
            }
            String string = StringUtil.read(inputStream);
            return string;
        }
    }

    public static String read(InputStream inputStream) throws IOException {
        String s = StringUtil._read(inputStream);
        s = StringUtil.replace(s, "\r\n", "\n");
        s = StringUtil.replace(s, '\r', '\n');
        return s.trim();
    }

    public static String replace(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return s.replace(oldSub, newSub);
    }

    public static String replace(String s, String oldSub, String newSub) {
        return StringUtil.replace(s, oldSub, newSub, 0);
    }

    public static String replace(String s, String oldSub, String newSub, int fromIndex) {
        int y;
        if (s == null) {
            return null;
        }
        if (oldSub == null || oldSub.equals("")) {
            return s;
        }
        if (newSub == null) {
            newSub = "";
        }
        if ((y = s.indexOf(oldSub, fromIndex)) >= 0) {
            StringBundler sb = new StringBundler();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                sb.append(newSub);
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static List<String> split(String s) {
        return StringUtil.split(s, ',');
    }

    public static List<String> split(String s, char delimiter) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        if ((s = s.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> elements = new ArrayList<String>();
        StringUtil._split(elements, s, delimiter);
        return elements;
    }

    private static String _read(InputStream inputStream) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        int offset = 0;
        while ((count = inputStream.read(buffer, offset, buffer.length - offset)) != -1) {
            if ((offset += count) != buffer.length) continue;
            byte[] newBuffer = new byte[buffer.length << 1];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        if (offset == 0) {
            return "";
        }
        return new String(buffer, 0, offset, "UTF-8");
    }

    private static void _split(List<String> values, String s, char delimiter) {
        int pos;
        int offset = 0;
        while ((pos = s.indexOf(delimiter, offset)) != -1) {
            if (offset < pos) {
                values.add(s.substring(offset, pos));
            }
            offset = pos + 1;
        }
        if (offset < s.length()) {
            values.add(s.substring(offset));
        }
    }
}

