/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseChainedMethodCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BaseBuilderCheck
extends BaseChainedMethodCheck {
    private static final String _CHECK_INLINE = "checkInline";
    private static final String _ENFORCE_BUILDER_NAMES_KEY = "enforceBuilderNames";
    private static final String _MSG_INCLUDE_BUILDER = "builder.include";
    private static final String _MSG_INCORRECT_NULL_VALUE = "null.value.incorrect";
    private static final String _MSG_INLINE_BUILDER_1 = "builder.inline.1";
    private static final String _MSG_INLINE_BUILDER_2 = "builder.inline.2";
    private static final String _MSG_INLINE_IF_STATEMENT = "if.statement.inline";
    private static final String _MSG_RESERVED_KEYWORD = "keyword.reserved";
    private static final String _MSG_UNNEEDED_STRING_CAST = "string.cast.unneeded";
    private static final String _MSG_USE_BUILD_STRING = "build.string.use";
    private static final String _MSG_USE_BUILDER = "builder.use";
    private static final String _MSG_USE_BUILDER_INSTEAD = "builder.use.instead";

    public int[] getDefaultTokens() {
        return new int[]{80, 11, 27};
    }

    protected abstract boolean allowNullValues();

    protected abstract List<BuilderInformation> doGetBuilderInformationList();

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this.isExcludedPath("run.outside.portal.excludes") || ListUtil.isEmpty(this.getAttributeValues(_ENFORCE_BUILDER_NAMES_KEY))) {
            return;
        }
        if (detailAST.getType() == 11) {
            this._checkAnonymousClass(detailAST);
            return;
        }
        if (detailAST.getType() == 27) {
            this._checkBuilder(detailAST);
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28 && parentDetailAST.getType() != 10) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        String variableName = this.getVariableName(detailAST, parentDetailAST);
        if (variableName != null) {
            this._checkAssignVariableStatement(detailAST, variableName, nextSiblingDetailAST);
        }
    }

    protected abstract String getAssignClassName(DetailAST var1);

    protected List<String> getAvoidCastStringMethodNames() {
        return Collections.emptyList();
    }

    protected List<BuilderInformation> getBuilderInformationList() {
        List<BuilderInformation> builderInformationList = this.doGetBuilderInformationList();
        List<String> enforceBuilderNames = this.getAttributeValues(_ENFORCE_BUILDER_NAMES_KEY);
        return ListUtil.filter(builderInformationList, builderInformation -> enforceBuilderNames.contains(builderInformation.getBuilderClassName()));
    }

    protected String getNewInstanceTypeName(DetailAST assignDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        DetailAST parentDetailAST = assignDetailAST.getParent();
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST == null || assignValueDetailAST.getType() != 136) {
            return null;
        }
        return this.getName(assignValueDetailAST);
    }

    protected Map<String, String[][]> getReservedKeywordsMap() {
        return Collections.emptyMap();
    }

    protected abstract List<String> getSupportsFunctionMethodNames();

    protected abstract boolean isSupportsNestedMethodCalls();

    private List<int[]> _addNonfinalVariableRangeList(List<int[]> nonfinalVariableRangeList, DetailAST detailAST) {
        if (nonfinalVariableRangeList == null) {
            nonfinalVariableRangeList = new ArrayList<int[]>();
        }
        List<String> variableNames = this._getVariableNames(detailAST);
        for (String variableName : variableNames) {
            DetailAST variableTypeDetailAST = this.getVariableTypeDetailAST(detailAST, variableName);
            if (variableTypeDetailAST == null) {
                String[] lines = this.getLines();
                nonfinalVariableRangeList.add(new int[]{0, lines.length});
                continue;
            }
            DetailAST variableDefinitionDetailAST = variableTypeDetailAST.getParent();
            DetailAST parentDetailAST = variableDefinitionDetailAST.getParent();
            if (parentDetailAST.getType() == 6) {
                DetailAST modifiersDetailAST;
                if (AnnotationUtil.containsAnnotation((DetailAST)variableDefinitionDetailAST, (String)"Reference") || (modifiersDetailAST = variableDefinitionDetailAST.findFirstToken(5)) != null && modifiersDetailAST.branchContains(39)) continue;
                nonfinalVariableRangeList.add(new int[]{this.getStartLineNumber(parentDetailAST), this.getEndLineNumber(parentDetailAST)});
                continue;
            }
            boolean isFinal = true;
            int start = this.getStartLineNumber(variableDefinitionDetailAST);
            int end = this.getEndLineNumber(variableDefinitionDetailAST);
            List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefinitionDetailAST, variableName);
            for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
                parentDetailAST = variableCallerDetailAST.getParent();
                if (parentDetailAST.getType() == 80 || parentDetailAST.getType() == 106 || parentDetailAST.getType() == 108 || parentDetailAST.getType() == 107 || parentDetailAST.getType() == 130 || parentDetailAST.getType() == 101 || parentDetailAST.getType() == 129 || parentDetailAST.getType() == 99 || parentDetailAST.getType() == 102 || parentDetailAST.getType() == 98 || parentDetailAST.getType() == 26 || parentDetailAST.getType() == 25 || parentDetailAST.getType() == 105 || parentDetailAST.getType() == 103 || parentDetailAST.getType() == 100) {
                    isFinal = false;
                }
                end = Math.max(end, this.getEndLineNumber(variableCallerDetailAST));
            }
            if (isFinal) continue;
            nonfinalVariableRangeList.add(new int[]{start, end});
        }
        return nonfinalVariableRangeList;
    }

    private void _checkAnonymousClass(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        String className = this.getName(parentDetailAST);
        if (className == null) {
            return;
        }
        BuilderInformation builderInformation = this._findBuilderInformationByClassName(className);
        if (builderInformation == null) {
            return;
        }
        List<DetailAST> childDetailASTList = this.getAllChildTokens(detailAST, true, -1);
        for (DetailAST childDetailAST : childDetailASTList) {
            if (this.getHiddenBefore(childDetailAST) == null) continue;
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST firstChildDetailAST;
            parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() != 28 || (parentDetailAST = parentDetailAST.getParent()).getType() != 7 || (firstChildDetailAST = methodCallDetailAST.getFirstChild()).getType() != 58) continue;
            if (!ArrayUtil.contains(builderInformation.getMethodNames(), firstChildDetailAST.getText())) {
                return;
            }
            if (this.isSupportsNestedMethodCalls()) {
                parentDetailAST = this.getParentWithTokenType(methodCallDetailAST, 175, 181, 91, 95, 84);
                if (parentDetailAST != null && detailAST.getLineNo() <= parentDetailAST.getLineNo()) {
                    return;
                }
                parentDetailAST = this.getParentWithTokenType(methodCallDetailAST, 92);
                if (parentDetailAST != null && detailAST.getLineNo() <= parentDetailAST.getLineNo() && (firstChildDetailAST = parentDetailAST.getFirstChild()).getType() == 83) {
                    return;
                }
            } else if (!this.equals(parentDetailAST.getParent(), detailAST)) {
                return;
            }
            if (this.allowNullValues()) continue;
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            for (DetailAST childDetailAST = elistDetailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
                if (!this._isNullValueExpression(childDetailAST)) continue;
                return;
            }
        }
        this.log(detailAST, _MSG_USE_BUILDER_INSTEAD, new Object[]{builderInformation.getBuilderClassName(), className});
    }

    private void _checkAssignVariableStatement(DetailAST assignDetailAST, String variableName, DetailAST nextSiblingDetailAST) {
        BuilderInformation builderInformation = this._findBuilderInformationByClassName(this.getAssignClassName(assignDetailAST));
        if (builderInformation == null) {
            return;
        }
        do {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null || this.hasPrecedingPlaceholder(nextSiblingDetailAST)) {
                return;
            }
            FullIdent fullIdent = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, builderInformation.getMethodNames());
            if (fullIdent == null) continue;
            DetailAST methodCallDetailAST = nextSiblingDetailAST.findFirstToken(27);
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            DetailAST childDetailAST = elistDetailAST.getFirstChild();
            while (true) {
                if (childDetailAST == null) {
                    this.log(assignDetailAST, _MSG_USE_BUILDER, new Object[]{builderInformation.getBuilderClassName(), assignDetailAST.getLineNo(), fullIdent.getLineNo()});
                    return;
                }
                if (!this.allowNullValues() && this._isNullValueExpression(childDetailAST) || this.containsVariableName(childDetailAST, variableName, true)) {
                    return;
                }
                childDetailAST = childDetailAST.getNextSibling();
            }
        } while (!this.containsVariableName(nextSiblingDetailAST, variableName, true));
    }

    private void _checkBuilder(DetailAST methodCallDetailAST) {
        DetailAST greatGrandParentDetailAST;
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58) {
            return;
        }
        String builderClassName = firstChildDetailAST.getText();
        BuilderInformation builderInformation = this._findBuilderInformationByBuilderClassName(builderClassName);
        if (builderInformation == null) {
            return;
        }
        this._checkUnneededCastString(methodCallDetailAST);
        Map<String, List<DetailAST>> expressionDetailASTMap = this._getExpressionDetailASTMap(methodCallDetailAST, false);
        if (!this.allowNullValues()) {
            this._checkNullValues(expressionDetailASTMap, builderClassName);
        }
        this._checkReservedKeywords(expressionDetailASTMap);
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        int endLineNumber = this.getEndLineNumber(parentDetailAST);
        int startLineNumber = this.getStartLineNumber(parentDetailAST);
        while (parentDetailAST.getType() == 59 || parentDetailAST.getType() == 28 || parentDetailAST.getType() == 27) {
            endLineNumber = this.getEndLineNumber(parentDetailAST);
            startLineNumber = this.getStartLineNumber(parentDetailAST);
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() == 34) {
            while (true) {
                DetailAST grandParentDetailAST;
                if ((grandParentDetailAST = parentDetailAST.getParent()) == null) {
                    return;
                }
                if (grandParentDetailAST.getType() == 7) {
                    this._checkInline(parentDetailAST, expressionDetailASTMap, builderClassName, startLineNumber, endLineNumber);
                    return;
                }
                parentDetailAST = grandParentDetailAST;
            }
        }
        if (parentDetailAST.getType() == 88) {
            this._checkInline(parentDetailAST, expressionDetailASTMap, builderClassName, startLineNumber, endLineNumber);
            return;
        }
        if (parentDetailAST.getType() != 80) {
            return;
        }
        DetailAST assignDetailAST = parentDetailAST;
        DetailAST grandParentDetailAST = (parentDetailAST = assignDetailAST.getParent()).getParent();
        if (grandParentDetailAST.getType() == 6 && (greatGrandParentDetailAST = grandParentDetailAST.getParent()).getType() == 14) {
            return;
        }
        this._checkInline(parentDetailAST, expressionDetailASTMap, builderClassName, startLineNumber, endLineNumber);
        if (this.isJSPFile()) {
            return;
        }
        String variableName = this.getVariableName(assignDetailAST, parentDetailAST);
        this._checkBuildString(methodCallDetailAST, assignDetailAST, variableName, startLineNumber, endLineNumber);
        this._checkInlineIfStatement(parentDetailAST, builderClassName, variableName, firstChildDetailAST.getLineNo());
        firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST == null || assignValueDetailAST.getType() != 27) {
            return;
        }
        List<String> variableNames = this._getVariableNames(parentDetailAST, "get.*");
        String[] builderMethodNames = builderInformation.getMethodNames();
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        while (nextSiblingDetailAST != null) {
            FullIdent fullIdent = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, builderMethodNames);
            if (fullIdent != null) {
                if (this._hasVariableNameInMethodCall(nextSiblingDetailAST.findFirstToken(27), variableName)) {
                    return;
                }
                this.log(assignDetailAST, _MSG_INCLUDE_BUILDER, new Object[]{fullIdent.getText(), fullIdent.getLineNo(), builderClassName, assignDetailAST.getLineNo()});
                return;
            }
            if (this.containsVariableName(nextSiblingDetailAST, variableName, false)) {
                return;
            }
            for (String curVariableName : variableNames) {
                if (!this.containsVariableName(nextSiblingDetailAST, curVariableName, true)) continue;
                return;
            }
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return;
    }

    private void _checkBuildString(DetailAST methodCallDetailAST, DetailAST assignDetailAST, String variableName, int startLineNumber, int endLineNumber) {
        DetailAST secondToLastDetailAST;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        if (!className.endsWith("URLBuilderCheck")) {
            return;
        }
        List<String> chainedMethodNames = this.getChainedMethodNames(methodCallDetailAST);
        String methodName = chainedMethodNames.get(chainedMethodNames.size() - 1);
        if (methodName.equals("buildString")) {
            return;
        }
        DetailAST variableDefinitionDetailAST = this.getVariableDefinitionDetailAST(assignDetailAST, variableName, false);
        if (variableDefinitionDetailAST == null) {
            return;
        }
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefinitionDetailAST, variableName);
        DetailAST lastDetailAST = variableCallerDetailASTList.get(variableCallerDetailASTList.size() - 1);
        if (lastDetailAST.getLineNo() <= endLineNumber) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)lastDetailAST.getParent());
        if (!Objects.equals(fullIdent.getText(), variableName + ".toString")) {
            return;
        }
        if (variableCallerDetailASTList.size() > 1 && (secondToLastDetailAST = variableCallerDetailASTList.get(variableCallerDetailASTList.size() - 2)).getLineNo() > startLineNumber) {
            return;
        }
        if (this.equals(variableDefinitionDetailAST, assignDetailAST.getParent()) || this.equals(this.getParentWithTokenType(assignDetailAST, 7), this.getParentWithTokenType(lastDetailAST, 7))) {
            this.log(fullIdent.getLineNo(), _MSG_USE_BUILD_STRING, new Object[]{variableName, methodName});
        }
    }

    private void _checkInline(DetailAST variableDefinitionDetailAST, DetailAST parentDetailAST, String builderClassName, List<String> supportsFunctionMethodNames, Map<String, List<DetailAST>> expressionDetailASTMap, int startLineNumber, int endlineNumber) {
        DetailAST literalCatchDetailAST;
        DetailAST identDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        String matchingMethodName = this._getInlineExpressionMethodName(expressionDetailASTMap, ListUtil.fromArray(identDetailAST));
        if (!supportsFunctionMethodNames.contains(matchingMethodName)) {
            return;
        }
        List<DetailAST> dependentIdentDetailASTList = this.getDependentIdentDetailASTList(variableDefinitionDetailAST, startLineNumber);
        if (dependentIdentDetailASTList.isEmpty()) {
            return;
        }
        List<int[]> nonfinalVariableRangeList = this._addNonfinalVariableRangeList(null, variableDefinitionDetailAST);
        String variableName = identDetailAST.getText();
        for (int i = dependentIdentDetailASTList.size() - 1; i >= 0; --i) {
            DetailAST dependentIdentDetailAST = dependentIdentDetailASTList.get(i);
            if (!variableName.equals(dependentIdentDetailAST.getText()) || dependentIdentDetailAST.getLineNo() <= endlineNumber) continue;
            return;
        }
        matchingMethodName = this._getInlineExpressionMethodName(expressionDetailASTMap, dependentIdentDetailASTList);
        if (matchingMethodName == null) {
            return;
        }
        DetailAST literalTryDetailAST = this.getParentWithTokenType(variableDefinitionDetailAST, 95);
        if (literalTryDetailAST != null && ((literalCatchDetailAST = this.getParentWithTokenType(variableDefinitionDetailAST, 96)) == null || literalCatchDetailAST.getLineNo() < literalTryDetailAST.getLineNo())) {
            return;
        }
        List<DetailAST> additionalDependentDetailASTList = this._getAdditionalDependentDetailASTList(dependentIdentDetailASTList, variableDefinitionDetailAST.getLineNo(), startLineNumber);
        if (additionalDependentDetailASTList.isEmpty()) {
            if (!this._hasNonfinalVariableReference(nonfinalVariableRangeList, this.getStartLineNumber(variableDefinitionDetailAST), this.getStartLineNumber(variableDefinitionDetailAST))) {
                this.log(identDetailAST, _MSG_INLINE_BUILDER_1, new Object[]{identDetailAST.getText(), identDetailAST.getLineNo(), builderClassName, startLineNumber});
            }
            return;
        }
        DetailAST lastAdditionalDependentDetailAST = additionalDependentDetailASTList.get(additionalDependentDetailASTList.size() - 1);
        if (lastAdditionalDependentDetailAST.getLineNo() >= parentDetailAST.getLineNo()) {
            return;
        }
        for (DetailAST additionalDependentDetailAST : additionalDependentDetailASTList) {
            DetailAST firstChildDetailAST;
            List<DetailAST> assignDetailASTList = this.getAllChildTokens(additionalDependentDetailAST, true, 80);
            for (DetailAST assignDetailAST : assignDetailASTList) {
                String assignVariableName = null;
                firstChildDetailAST = assignDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 58) {
                    assignVariableName = firstChildDetailAST.getText();
                } else {
                    DetailAST previousSiblingDetailAST = assignDetailAST.getPreviousSibling();
                    if (previousSiblingDetailAST != null && previousSiblingDetailAST.getType() == 58) {
                        assignVariableName = previousSiblingDetailAST.getText();
                    }
                }
                if (assignVariableName == null) {
                    return;
                }
                if (!variableName.equals(assignVariableName)) {
                    for (int i = dependentIdentDetailASTList.size() - 1; i >= 0; --i) {
                        DetailAST dependentIdentDetailAST = dependentIdentDetailASTList.get(i);
                        if (!assignVariableName.equals(dependentIdentDetailAST.getText()) || dependentIdentDetailAST.getLineNo() <= endlineNumber) continue;
                        return;
                    }
                }
                nonfinalVariableRangeList = this._addNonfinalVariableRangeList(nonfinalVariableRangeList, additionalDependentDetailAST);
            }
            if (this._hasNonfinalVariableReference(nonfinalVariableRangeList, this.getStartLineNumber(variableDefinitionDetailAST), this.getEndLineNumber(lastAdditionalDependentDetailAST))) {
                return;
            }
            List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(additionalDependentDetailAST, true, 27);
            for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
                firstChildDetailAST = methodCallDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 59) {
                    FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
                    String methodCall = fullIdent.getText();
                    if (methodCall.startsWith(variableName + ".") || methodCall.contains(".get")) continue;
                    return;
                }
                if (firstChildDetailAST.getType() == 58) {
                    String methodName = firstChildDetailAST.getText();
                    if (methodName.matches("_?get.*")) continue;
                    return;
                }
                return;
            }
        }
        this.log(identDetailAST, _MSG_INLINE_BUILDER_2, new Object[]{variableName, identDetailAST.getLineNo(), this._getLineNumbers(additionalDependentDetailASTList), builderClassName, startLineNumber});
    }

    private void _checkInline(DetailAST parentDetailAST, Map<String, List<DetailAST>> expressionDetailASTMap, String builderClassName, int startLineNumber, int endLineNumber) {
        DetailAST branchingStatementDetailAST;
        int lineNumber;
        if (!this.isAttributeValue(_CHECK_INLINE)) {
            return;
        }
        List<String> supportsFunctionMethodNames = this.getSupportsFunctionMethodNames();
        if (supportsFunctionMethodNames.isEmpty()) {
            return;
        }
        int branchStatementLineNumber = -1;
        List<DetailAST> branchingStatementDetailASTList = this.getAllChildTokens(parentDetailAST.getParent(), true, 86, 87, 88);
        Iterator<DetailAST> iterator = branchingStatementDetailASTList.iterator();
        while (iterator.hasNext() && (lineNumber = (branchingStatementDetailAST = iterator.next()).getLineNo()) < startLineNumber) {
            branchStatementLineNumber = lineNumber;
        }
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(parentDetailAST.getParent(), false, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            int lineNumber2 = variableDefinitionDetailAST.getLineNo();
            if (lineNumber2 >= startLineNumber) {
                return;
            }
            if (branchStatementLineNumber >= lineNumber2) continue;
            this._checkInline(variableDefinitionDetailAST, parentDetailAST, builderClassName, supportsFunctionMethodNames, expressionDetailASTMap, startLineNumber, endLineNumber);
        }
    }

    private void _checkInlineIfStatement(DetailAST parentDetailAST, String builderClassName, String variableName, int lineNumber) {
        List<String> supportsFunctionMethodNames = this.getSupportsFunctionMethodNames();
        if (supportsFunctionMethodNames.isEmpty()) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() != 45) {
            return;
        }
        DetailAST detailAST = nextSiblingDetailAST.getNextSibling();
        int rangeLineNumber = -1;
        int startLineNumber = -1;
        List<int[]> nonfinalVariableRangeList = new ArrayList<int[]>();
        while (true) {
            if (detailAST.getType() == 45) {
                detailAST = detailAST.getNextSibling();
                continue;
            }
            DetailAST variableDefinitionDetailAST = null;
            if (detailAST.getType() == 28) {
                DetailAST firstChildDetailAST = detailAST.getFirstChild();
                if (firstChildDetailAST.getType() != 80) {
                    return;
                }
                String name = this.getName(firstChildDetailAST);
                if (name == null) {
                    return;
                }
                variableDefinitionDetailAST = this.getVariableDefinitionDetailAST(detailAST, name, false);
            } else if (detailAST.getType() == 10) {
                variableDefinitionDetailAST = detailAST;
            }
            if (variableDefinitionDetailAST == null) break;
            List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefinitionDetailAST);
            if (variableCallerDetailASTList.isEmpty()) {
                return;
            }
            nonfinalVariableRangeList = this._addNonfinalVariableRangeList(nonfinalVariableRangeList, variableDefinitionDetailAST);
            DetailAST lastDetailAST = variableCallerDetailASTList.get(variableCallerDetailASTList.size() - 1);
            if (startLineNumber == -1) {
                startLineNumber = this.getStartLineNumber(detailAST);
            }
            rangeLineNumber = Math.max(rangeLineNumber, lastDetailAST.getLineNo());
            detailAST = detailAST.getNextSibling();
        }
        ArrayList<DetailAST> slistDetailASTList = new ArrayList<DetailAST>();
        int endLineNumber = -1;
        while (detailAST != null && (detailAST.getType() == 92 || detailAST.getType() == 83)) {
            DetailAST slistDetailAST;
            if (startLineNumber == -1) {
                startLineNumber = this.getStartLineNumber(detailAST);
            }
            if (endLineNumber == -1) {
                nonfinalVariableRangeList = this._addNonfinalVariableRangeList(nonfinalVariableRangeList, detailAST);
                endLineNumber = this.getEndLineNumber(detailAST);
                if (rangeLineNumber > endLineNumber) {
                    return;
                }
            }
            if (detailAST.getType() == 92) {
                DetailAST firstChildDetailAST = detailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 7) {
                    slistDetailASTList.add(firstChildDetailAST);
                    break;
                }
                if (firstChildDetailAST.getType() != 83) {
                    return;
                }
                detailAST = firstChildDetailAST;
            }
            if ((slistDetailAST = detailAST.findFirstToken(7)) == null) {
                return;
            }
            slistDetailASTList.add(slistDetailAST);
            detailAST = slistDetailAST.getNextSibling();
        }
        if (slistDetailASTList.isEmpty()) {
            return;
        }
        String methodKey = null;
        for (DetailAST slistDetailAST : slistDetailASTList) {
            String curMethodKey = this._getMethodKey(slistDetailAST, variableName, supportsFunctionMethodNames);
            if (curMethodKey == null) {
                return;
            }
            if (methodKey == null) {
                methodKey = curMethodKey;
                continue;
            }
            if (methodKey.equals(curMethodKey)) continue;
            return;
        }
        if (!this._hasNonfinalVariableReference(nonfinalVariableRangeList, startLineNumber, endLineNumber)) {
            this.log(startLineNumber, _MSG_INLINE_IF_STATEMENT, new Object[]{builderClassName, lineNumber});
        }
    }

    private void _checkNullValues(Map<String, List<DetailAST>> expressionDetailASTMap, String builderClassName) {
        for (Map.Entry<String, List<DetailAST>> entry : expressionDetailASTMap.entrySet()) {
            for (DetailAST expressionDetailAST : entry.getValue()) {
                if (!this._isNullValueExpression(expressionDetailAST)) continue;
                this.log(expressionDetailAST, _MSG_INCORRECT_NULL_VALUE, new Object[]{builderClassName});
            }
        }
    }

    private void _checkReservedKeywords(Map<String, List<DetailAST>> expressionDetailASTMap) {
        Map<String, String[][]> reservedKeywordsMap = this.getReservedKeywordsMap();
        for (Map.Entry<String, String[][]> entry : reservedKeywordsMap.entrySet()) {
            String methodName = entry.getKey();
            List<DetailAST> expressionDetailASTList = expressionDetailASTMap.get(methodName);
            if (expressionDetailASTList == null) continue;
            block1: for (DetailAST expressionDetailAST : expressionDetailASTList) {
                String[][] reservedKeywordsArray;
                DetailAST previousDetailAST = expressionDetailAST.getPreviousSibling();
                if (previousDetailAST != null) continue;
                DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
                String value = null;
                if (firstChildDetailAST.getType() == 139) {
                    value = StringUtil.removeChar(firstChildDetailAST.getText(), '\"');
                } else {
                    if (firstChildDetailAST.getType() != 59) continue;
                    FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
                    value = fullIdent.getText();
                }
                for (String[] reservedKeywordArray : reservedKeywordsArray = entry.getValue()) {
                    String reservedKey = reservedKeywordArray[0];
                    if (!value.equals(reservedKey)) continue;
                    this.log(expressionDetailAST, _MSG_RESERVED_KEYWORD, new Object[]{methodName, value, reservedKeywordArray[1]});
                    continue block1;
                }
            }
        }
    }

    private void _checkUnneededCastString(DetailAST methodCallDetailAST) {
        List<String> avoidCastStringMethodNames = this.getAvoidCastStringMethodNames();
        if (avoidCastStringMethodNames.isEmpty()) {
            return;
        }
        Map<String, List<DetailAST>> expressionDetailASTMap = this._getExpressionDetailASTMap(methodCallDetailAST, true);
        for (String avoidCastStringMethodName : this.getAvoidCastStringMethodNames()) {
            List<DetailAST> expressionDetailASTList = expressionDetailASTMap.get(avoidCastStringMethodName);
            if (expressionDetailASTList == null) continue;
            for (DetailAST expressionDetailAST : expressionDetailASTList) {
                FullIdent fullIdent;
                String methodCall;
                DetailAST childDetailAST;
                if (expressionDetailAST.getType() != 28 || (childDetailAST = expressionDetailAST.getFirstChild()).getType() != 27 || !(methodCall = (fullIdent = FullIdent.createFullIdentBelow((DetailAST)childDetailAST)).getText()).equals("String.valueOf") && !methodCall.endsWith(".toString")) continue;
                this.log(expressionDetailAST, _MSG_UNNEEDED_STRING_CAST, new Object[]{avoidCastStringMethodName});
            }
        }
    }

    private BuilderInformation _findBuilderInformationByBuilderClassName(String builderClassName) {
        for (BuilderInformation builderInformation : this.getBuilderInformationList()) {
            if (!builderClassName.equals(builderInformation.getBuilderClassName())) continue;
            return builderInformation;
        }
        return null;
    }

    private BuilderInformation _findBuilderInformationByClassName(String className) {
        if (className == null) {
            return null;
        }
        for (BuilderInformation builderInformation : this.getBuilderInformationList()) {
            if (!className.equals(builderInformation.getClassName())) continue;
            return builderInformation;
        }
        return null;
    }

    private List<DetailAST> _getAdditionalDependentDetailASTList(List<DetailAST> dependentIdentDetailASTList, int startLineNumber, int endLineNumber) {
        ArrayList<DetailAST> dependentDetailASTList = new ArrayList<DetailAST>();
        block0: for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            if (dependentIdentDetailAST.getLineNo() >= endLineNumber) {
                return dependentDetailASTList;
            }
            DetailAST detailAST = dependentIdentDetailAST;
            while (true) {
                DetailAST parentDetailAST;
                if ((parentDetailAST = detailAST.getParent()).getLineNo() < startLineNumber) {
                    if (dependentDetailASTList.contains(detailAST)) continue block0;
                    dependentDetailASTList.add(detailAST);
                    continue block0;
                }
                detailAST = parentDetailAST;
            }
        }
        return dependentDetailASTList;
    }

    private Map<String, List<DetailAST>> _getExpressionDetailASTMap(DetailAST methodCallDetailAST, boolean lastExpressionOnly) {
        HashMap<String, List<DetailAST>> expressionDetailASTMap = new HashMap<String, List<DetailAST>>();
        while (true) {
            DetailAST parentDetailAST;
            DetailAST childDetailAST;
            String methodName;
            ArrayList<DetailAST> expressionDetailASTList;
            if ((expressionDetailASTList = (ArrayList<DetailAST>)expressionDetailASTMap.get(methodName = this.getMethodName(methodCallDetailAST))) == null) {
                expressionDetailASTList = new ArrayList<DetailAST>();
            }
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            if (lastExpressionOnly) {
                childDetailAST = elistDetailAST.getLastChild();
                if (childDetailAST != null) {
                    expressionDetailASTList.add(childDetailAST);
                }
            } else {
                for (childDetailAST = elistDetailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
                    if (childDetailAST.getType() == 74) continue;
                    expressionDetailASTList.add(childDetailAST);
                }
            }
            if (!expressionDetailASTList.isEmpty()) {
                expressionDetailASTMap.put(methodName, expressionDetailASTList);
            }
            if ((parentDetailAST = methodCallDetailAST.getParent()).getType() != 59) {
                return expressionDetailASTMap;
            }
            methodCallDetailAST = parentDetailAST.getParent();
        }
    }

    private String _getInlineExpressionMethodName(Map<String, List<DetailAST>> expressionDetailASTMap, List<DetailAST> dependentIdentDetailASTList) {
        String methodName = null;
        for (Map.Entry<String, List<DetailAST>> entry : expressionDetailASTMap.entrySet()) {
            block1: for (DetailAST expressionDetailAST : entry.getValue()) {
                List<String> variableNames = this._getVariableNames(expressionDetailAST);
                for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
                    if (!variableNames.contains(dependentIdentDetailAST.getText())) continue;
                    List<int[]> nonfinalVariableRangeList = this._addNonfinalVariableRangeList(null, expressionDetailAST);
                    for (int[] array : nonfinalVariableRangeList) {
                        if (expressionDetailAST.getLineNo() <= array[0]) continue;
                        return null;
                    }
                    if (methodName != null) {
                        return null;
                    }
                    methodName = entry.getKey();
                    continue block1;
                }
            }
        }
        return methodName;
    }

    private String _getLineNumbers(List<DetailAST> detailASTList) {
        StringBundler sb = new StringBundler(detailASTList.size() * 2);
        for (DetailAST detailAST : detailASTList) {
            sb.append(detailAST.getLineNo());
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private String _getMethodKey(DetailAST slistDetailAST, String variableName, List<String> supportsFunctionMethodNames) {
        DetailAST lastChildDetailAST = slistDetailAST.getLastChild();
        if (lastChildDetailAST.getType() != 73) {
            return null;
        }
        DetailAST previousSiblingDetailAST = lastChildDetailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 45) {
            return null;
        }
        if ((previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()) == null || previousSiblingDetailAST.getType() != 28) {
            return null;
        }
        DetailAST methodCallDetailAST = previousSiblingDetailAST.getFirstChild();
        if (methodCallDetailAST.getType() != 27) {
            return null;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        if (elistDetailAST == null) {
            return null;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            DetailAST exprChildDetailAST = exprDetailAST.getFirstChild();
            if (exprChildDetailAST.getType() != 135) continue;
            return null;
        }
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58 || !variableName.equals(firstChildDetailAST.getText())) {
            return null;
        }
        DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() != 58) {
            return null;
        }
        String methodName = nextSiblingDetailAST.getText();
        if (!supportsFunctionMethodNames.contains(methodName)) {
            return null;
        }
        String methodKey = methodName;
        if (exprDetailASTList.size() > 1) {
            FullIdent fullIdent = FullIdent.createFullIdentBelow((DetailAST)exprDetailASTList.get(0));
            methodKey = methodKey + ":" + fullIdent.getText();
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(slistDetailAST, true, 27);
        for (DetailAST curMethodCallDetailAST : methodCallDetailASTList) {
            if (this.equals(curMethodCallDetailAST, methodCallDetailAST) || (firstChildDetailAST = curMethodCallDetailAST.getFirstChild()).getType() != 59 || !variableName.equals((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getText())) continue;
            return null;
        }
        return methodKey;
    }

    private List<String> _getVariableNames(DetailAST detailAST) {
        return this._getVariableNames(detailAST, null);
    }

    private List<String> _getVariableNames(DetailAST detailAST, String excludeRegex) {
        ArrayList<String> variableNames = new ArrayList<String>();
        List<DetailAST> identDetailASTList = this.getAllChildTokens(detailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            DetailAST nextSiblingDetailAST;
            String variableName = identDetailAST.getText();
            if (!variableName.matches("[a-z_].*")) continue;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() == 80 || parentDetailAST.getType() == 28 || parentDetailAST.getType() == 23 || ArrayUtil.contains(ARITHMETIC_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(CONDITIONAL_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(RELATIONAL_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(UNARY_OPERATOR_TOKEN_TYPES, parentDetailAST.getType())) {
                variableNames.add(variableName);
                continue;
            }
            if (parentDetailAST.getType() != 59 || (nextSiblingDetailAST = identDetailAST.getNextSibling()) == null) continue;
            if (nextSiblingDetailAST.getType() != 58 || excludeRegex == null) {
                variableNames.add(variableName);
                continue;
            }
            String s = nextSiblingDetailAST.getText();
            if (s.matches(excludeRegex)) continue;
            variableNames.add(variableName);
        }
        return variableNames;
    }

    private boolean _hasNonfinalVariableReference(List<int[]> nonfinalVariableRangeList, int start, int end) {
        for (int[] range : nonfinalVariableRangeList) {
            int rangeStart = range[0];
            int rangeEnd = range[1];
            if (rangeStart >= start && rangeEnd <= end) continue;
            return true;
        }
        return false;
    }

    private boolean _hasVariableNameInMethodCall(DetailAST methodCallDetailAST, String variableName) {
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        for (String name : this.getNames(elistDetailAST, true)) {
            if (!variableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean _isNullValueExpression(DetailAST detailAST) {
        DetailAST lastChildDetailAST;
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 135) {
            return true;
        }
        return firstChildDetailAST.getType() == 23 && (lastChildDetailAST = firstChildDetailAST.getLastChild()).getType() == 135;
    }

    protected static class BuilderInformation {
        private final String _builderClassName;
        private final String _className;
        private final String[] _methodNames;

        public BuilderInformation(String className, String builderClassName, String ... methodNames) {
            this._className = className;
            this._builderClassName = builderClassName;
            this._methodNames = methodNames;
        }

        public String getBuilderClassName() {
            return this._builderClassName;
        }

        public String getClassName() {
            return this._className;
        }

        public String[] getMethodNames() {
            return this._methodNames;
        }
    }
}

