/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseEmptyLinesCheck;
import com.liferay.source.formatter.check.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPEmptyLinesCheck
extends BaseEmptyLinesCheck {
    private static final Pattern _missingEmptyLinePattern1 = Pattern.compile("[\t\n](--)?%>\n\t*(?!-->)\\S");
    private static final Pattern _missingEmptyLinePattern2 = Pattern.compile("\\S(?!<\\!--)\n\t*<%(--|\\!)?\n");
    private static final Pattern _missingEmptyLinePattern3 = Pattern.compile("[\t\n]<%\\!?\n\t*//");
    private static final Pattern _missingEmptyLinePattern4 = Pattern.compile("[\t\n]//.*\n\t*%>\n");
    private static final Pattern _redundantEmptyLinePattern1 = Pattern.compile("[\n\t]<%\\!?\n\n(\t*)[^/\n\t]");
    private static final Pattern _redundantEmptyLinePattern2 = Pattern.compile("[\n\t][^/\n\t].*\n\n\t*%>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLines(absolutePath, content);
        content = this.fixMissingEmptyLinesAroundComments(content);
        content = this.fixRedundantEmptyLines(content);
        content = this.fixIncorrectEmptyLineAfterOpenCurlyBrace(content);
        content = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(content);
        content = this.fixMissingEmptyLineAfterSettingVariable(content);
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this.fixEmptyLinesBetweenTags(content);
        content = this._fixMissingEmptyLines(content);
        content = this._fixRedundantEmptyLines(content);
        return content;
    }

    private String _fixMissingEmptyLines(String content) {
        Matcher matcher = _missingEmptyLinePattern1.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        matcher = _missingEmptyLinePattern2.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _missingEmptyLinePattern3.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        matcher = _missingEmptyLinePattern4.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        return content;
    }

    private String _fixRedundantEmptyLines(String content) {
        Matcher matcher = _redundantEmptyLinePattern1.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
        }
        matcher = _redundantEmptyLinePattern2.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJSSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
        }
        return content;
    }
}

