/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;

@StatelessCheck
public class JavadocMissingWhitespaceAfterAsteriskCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "javadoc.missing.whitespace";

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000, 1};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode detailNode) {
        String text;
        int lastAsteriskPosition;
        DetailNode textNode = detailNode.getType() == 10000 ? JavadocUtil.getFirstChild(detailNode) : JavadocUtil.getNextSibling(detailNode);
        if (textNode != null && textNode.getType() != -1 && !JavadocMissingWhitespaceAfterAsteriskCheck.isLast(lastAsteriskPosition = JavadocMissingWhitespaceAfterAsteriskCheck.getLastLeadingAsteriskPosition(text = textNode.getText()), text) && !Character.isWhitespace(text.charAt(lastAsteriskPosition + 1))) {
            this.log(textNode.getLineNumber(), textNode.getColumnNumber(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isLast(int position, String text) {
        return position == text.length() - 1;
    }

    private static int getLastLeadingAsteriskPosition(String text) {
        int index = -1;
        for (int i = 0; i < text.length() && text.charAt(i) == '*'; ++i) {
            ++index;
        }
        return index;
    }
}

