/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseStylingCheck
extends BaseFileCheck {
    private static final Pattern _booleanPattern = Pattern.compile("\\((\\!)?(\\w+)\\s+(==|!=)\\s+(false|true)\\)");
    private static final Pattern _objectsEqualsPattern = Pattern.compile("\\WObjects\\.equals\\(");
    private static final Pattern _redundantArrayInitializationPattern = Pattern.compile("\\W(\\w+)\\[\\]\\[\\] (\\w+ = )?\\{\n");

    protected String formatStyling(String content) {
        content = this._formatStyling(content, "!ArrayUtil.isEmpty(", "ArrayUtil.isNotEmpty(");
        content = this._formatStyling(content, "!ArrayUtil.isNotEmpty(", "ArrayUtil.isEmpty(");
        content = this._formatStyling(content, "!ListUtil.isEmpty(", "ListUtil.isNotEmpty(");
        content = this._formatStyling(content, "!ListUtil.isNotEmpty(", "ListUtil.isEmpty(");
        content = this._formatStyling(content, "!MapUtil.isEmpty(", "MapUtil.isNotEmpty(");
        content = this._formatStyling(content, "!MapUtil.isNotEmpty(", "MapUtil.isEmpty(");
        content = this._formatStyling(content, "!SetUtil.isEmpty(", "SetUtil.isNotEmpty(");
        content = this._formatStyling(content, "!SetUtil.isNotEmpty(", "SetUtil.isEmpty(");
        content = this._formatStyling(content, "!Validator.isNotNull(", "Validator.isNull(");
        content = this._formatStyling(content, "!Validator.isNull(", "Validator.isNotNull(");
        content = this._formatStyling(content, "\nfor (;;) {", "\nwhile (true) {");
        content = this._formatStyling(content, "\tfor (;;) {", "\twhile (true) {");
        content = this._formatStyling(content, "String.valueOf(false)", "Boolean.FALSE.toString()");
        content = this._formatStyling(content, "String.valueOf(true)", "Boolean.TRUE.toString()");
        content = this._formatObjectsEqualsMethodCall(content);
        content = this._formatToStringMethodCall(content, "Double");
        content = this._formatToStringMethodCall(content, "Float");
        content = this._formatToStringMethodCall(content, "Integer");
        content = this._formatToStringMethodCall(content, "Long");
        content = this._formatToStringMethodCall(content, "Objects");
        content = this._formatToStringMethodCall(content, "Short");
        content = this._fixBooleanStatement(content);
        content = this._fixRedundantArrayInitialization(content);
        content = this._fixRedundantArrayInitialization(content, "Arrays", "asList");
        return content;
    }

    private String _fixBooleanStatement(String content) {
        Matcher matcher = _booleanPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            boolean booleanValue = true;
            if (matcher.group(1) != null || Objects.equals(matcher.group(3), "!=") || Objects.equals(matcher.group(4), "false")) {
                boolean bl = booleanValue = !booleanValue;
            }
            if (booleanValue) {
                return StringUtil.replaceFirst(content, matcher.group(), "(" + matcher.group(2) + ")");
            }
            return StringUtil.replaceFirst(content, matcher.group(), "(!" + matcher.group(2) + ")");
        }
        return content;
    }

    private String _fixRedundantArrayInitialization(String content) {
        Matcher matcher = _redundantArrayInitializationPattern.matcher(content);
        while (matcher.find()) {
            int y;
            if (!this.isJavaSource(content, matcher.start())) continue;
            String typeName = matcher.group(1);
            int x = content.indexOf("new " + typeName + "[] {", matcher.end());
            if (x == -1 || x >= (y = this._getMatchingClosingCurlyBracePos(content, matcher.end() - 2))) continue;
            return StringUtil.replaceFirst(content, "new " + typeName + "[] {", "{", matcher.end());
        }
        return content;
    }

    private String _fixRedundantArrayInitialization(String content, String className, String methodName) {
        Pattern pattern = Pattern.compile(StringBundler.concat("\\W", className, "\\.", methodName, "\\(\\s*(new \\w+\\[\\] \\{)(\\w+)?"));
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            if (Objects.equals(matcher.group(2), "null") || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start()))).size() > 1) continue;
            int x = this._getMatchingClosingCurlyBracePos(content, matcher.end(1) - 1);
            content = StringUtil.replaceFirst(content, "}", "", x);
            content = StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
            return content;
        }
        return content;
    }

    private String _formatObjectsEqualsMethodCall(String content) {
        Matcher matcher = _objectsEqualsPattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || !this.isJavaSource(content, matcher.start()) || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start() + 1))).size() != 2) continue;
            String parameterName1 = parameterList.get(0);
            String parameterName2 = parameterList.get(1);
            if (!SourceUtil.isLiteralString(parameterName1) || SourceUtil.isLiteralString(parameterName2)) continue;
            int x = this._getMatchingClosingParenthesisPos(content, matcher.start() + 1);
            String methodCall = content.substring(matcher.start() + 1, x + 1);
            String newMethodCall = StringBundler.concat("Objects.equals(", parameterName2, ", ", parameterName1, ")");
            return StringUtil.replace(content, methodCall, newMethodCall);
        }
        return content;
    }

    private String _formatStyling(String content, String incorrectStyling, String correctStyling) {
        int x = -1;
        do {
            if ((x = content.indexOf(incorrectStyling, x + 1)) != -1) continue;
            return content;
        } while (Character.isLetterOrDigit(incorrectStyling.charAt(0)) && Character.isLetterOrDigit(content.charAt(x - 1)) || !this.isJavaSource(content, x));
        return StringUtil.replaceFirst(content, incorrectStyling, correctStyling);
    }

    private String _formatToStringMethodCall(String content, String className) {
        Pattern pattern = Pattern.compile(StringBundler.concat("\\W", className, "\\.toString\\((.*?)\\);\n"), 32);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            int pos = matcher.start();
            if (!this.isJavaSource(content, pos) || (parameterList = JavaSourceUtil.getParameterList(matcher.group())).size() != 1) continue;
            return StringUtil.replaceFirst(content, className + ".toString(", "String.valueOf(", pos);
        }
        return content;
    }

    private int _getMatchingClosingCurlyBracePos(String content, int start) {
        int x = start;
        while (this.getLevel(content.substring(start, (x = content.indexOf(125, x + 1)) + 1), "{", "}") != 0) {
        }
        return x;
    }

    private int _getMatchingClosingParenthesisPos(String content, int start) {
        int x = start;
        while (this.getLevel(content.substring(start, (x = content.indexOf(41, x + 1)) + 1), "(", ")") != 0 || this.getLevel(content.substring(start, x + 1), "{", "}") != 0) {
        }
        return x;
    }
}

