/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.processor.SourceProcessor;
import java.util.List;

public class CIMergeAndGitRepoFileCheck
extends BaseFileCheck {
    private static List<String> _currentBranchFileNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this.isSubrepository()) {
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        List<String> currentBranchFileNames = this._getCurrentBranchFileNames(sourceProcessor.getSourceFormatterArgs());
        for (String currentBranchFileName : currentBranchFileNames) {
            if (!absolutePath.endsWith(currentBranchFileName)) continue;
            this.addMessage(fileName, "Do not add/modify ci-merge and .gitrepo files");
            return content;
        }
        return content;
    }

    private synchronized List<String> _getCurrentBranchFileNames(SourceFormatterArgs sourceFormatterArgs) throws Exception {
        if (_currentBranchFileNames != null) {
            return _currentBranchFileNames;
        }
        _currentBranchFileNames = GitUtil.getCurrentBranchFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName());
        return _currentBranchFileNames;
    }
}

