/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorEqualsCheck
extends BaseFileCheck {
    private static final Pattern _validatorEqualsPattern = Pattern.compile("\\WValidator\\.equals\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkValidatorEquals(fileName, content);
        return content;
    }

    private void _checkValidatorEquals(String fileName, String content) {
        Matcher matcher = _validatorEqualsPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            this.addMessage(fileName, "Use Objects.equals(Object, Object) instead of Validator.equals(Object, Object)", this.getLineNumber(content, matcher.start()));
        }
    }
}

