/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;

public class PoshiWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._removeRedundantWhitespaceInTaskDescription(fileName, content);
    }

    private String _removeRedundantWhitespaceInTaskDescription(String fileName, String content) {
        if (!fileName.endsWith("macro") && !fileName.endsWith("testcase")) {
            return content;
        }
        String[] lines = content.split("\n");
        StringBundler sb = new StringBundler(lines.length * 2);
        for (String line : lines) {
            String trimmedLine = StringUtil.trim(line);
            if (!trimmedLine.startsWith("task (")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            String newLine = trimmedLine.replaceAll(" {2,}", " ");
            if (StringUtil.equals(trimmedLine, newLine)) {
                sb.append(line);
            } else {
                sb.append(StringUtil.replaceFirst(line, trimmedLine, newLine));
            }
            sb.append("\n");
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

