/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseEmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEmptyLinesCheck
extends BaseEmptyLinesCheck {
    private static final Pattern _redundantEmptyLinePattern = Pattern.compile("\n(.*)-> \\{\n\n[\t ]*(?!// )\\S");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLines(absolutePath, content);
        content = this.fixMissingEmptyLinesAroundComments(content);
        content = this.fixRedundantEmptyLines(content);
        content = this.fixMissingEmptyLineAfterSettingVariable(content);
        content = this._fixRedundantEmptyLineInLambdaExpression(content);
        return content;
    }

    private String _fixRedundantEmptyLineInLambdaExpression(String content) {
        Matcher matcher = _redundantEmptyLinePattern.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group(1)) != 0) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }
}

