/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaElseStatementCheck
extends BaseJavaTermCheck {
    private static final Pattern _elseStatementPattern = Pattern.compile("\\}\n\t*else \\{\n");
    private static final Pattern _exitStatementPattern = Pattern.compile("\\s(break|continue|return|throw)[\\s;]");
    private static final Pattern _ifStatementPattern = Pattern.compile("\\sif\\s*\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent = javaTerm.getContent();
        Matcher matcher1 = _elseStatementPattern.matcher(javaTermContent);
        block0: while (matcher1.find()) {
            List<String> ifStatementCodeBlocks = this._getIfStatementCodeBlock(javaTermContent, matcher1.start());
            if (ListUtil.isEmpty(ifStatementCodeBlocks)) continue;
            String exitStatementType = null;
            for (String ifStatementCodeBlock : ifStatementCodeBlocks) {
                exitStatementType = null;
                Matcher matcher2 = _exitStatementPattern.matcher(ifStatementCodeBlock);
                while (matcher2.find()) {
                    String s;
                    if (ToolsUtil.isInsideQuotes(ifStatementCodeBlock, matcher2.start()) || this.getLevel(s = ifStatementCodeBlock.substring(0, matcher2.start()), "{", "}") != 1) continue;
                    exitStatementType = matcher2.group(1);
                    break;
                }
                if (exitStatementType != null) continue;
                continue block0;
            }
            if (exitStatementType == null) continue;
            int closeCurlyBracePos = this._getCloseCurlyBracePos(javaTermContent, matcher1.start() + 2);
            String endLine = this.getLine(javaTermContent, this.getLineNumber(javaTermContent, closeCurlyBracePos));
            if (Objects.equals(StringUtil.trim(endLine), "}")) {
                String elseStatement = javaTermContent.substring(matcher1.start() + 2, closeCurlyBracePos + 1);
                if (!this._containsVariableName(javaTermContent.substring(closeCurlyBracePos), this.getVariableNames(elseStatement))) {
                    int x = elseStatement.indexOf(10);
                    int y = elseStatement.lastIndexOf(10);
                    String replacement = "";
                    if (x != y) {
                        replacement = StringUtil.replace(elseStatement.substring(x, y), "\n\t", "\n");
                    }
                    return StringUtil.replaceFirst(javaTermContent, elseStatement, replacement, matcher1.start());
                }
            }
            int x = javaTermContent.lastIndexOf(exitStatementType, matcher1.start());
            this.addMessage(fileName, StringBundler.concat("Else statement is not needed because of the \"", exitStatementType, "\" statement on line ", javaTerm.getLineNumber(x)), javaTerm.getLineNumber(matcher1.start() + 3));
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private boolean _containsVariableName(String s, List<String> variableNames) {
        for (String variableName : variableNames) {
            if (!s.matches("(?s).*\\W" + variableName + "\\W.*")) continue;
            return true;
        }
        return false;
    }

    private int _getCloseCurlyBracePos(String content, int x) {
        int y = x;
        do {
            if ((y = content.indexOf("}", y + 1)) != -1) continue;
            return -1;
        } while (this.getLevel(content.substring(x, y + 1), "{", "}") != 0);
        return y;
    }

    private List<String> _getElseIfStatementCodeBlock(String content, int closeCurlyBracePos, int x) {
        int openCurlyBracePos = content.indexOf("{", closeCurlyBracePos + 1);
        if (openCurlyBracePos == -1) {
            return Collections.emptyList();
        }
        String statement = StringUtil.trim(content.substring(closeCurlyBracePos + 1, openCurlyBracePos));
        if (!statement.startsWith("else if")) {
            return Collections.emptyList();
        }
        closeCurlyBracePos = this._getCloseCurlyBracePos(content, openCurlyBracePos);
        if (closeCurlyBracePos == -1) {
            return Collections.emptyList();
        }
        ArrayList<String> elseIfStatementCodeBlocks = new ArrayList<String>();
        elseIfStatementCodeBlocks.add(content.substring(openCurlyBracePos, closeCurlyBracePos + 1));
        if (closeCurlyBracePos == x) {
            return elseIfStatementCodeBlocks;
        }
        List<String> nestedElseIfStatementCodeBlocks = this._getElseIfStatementCodeBlock(content, closeCurlyBracePos, x);
        if (nestedElseIfStatementCodeBlocks.isEmpty()) {
            return Collections.emptyList();
        }
        elseIfStatementCodeBlocks.addAll(nestedElseIfStatementCodeBlocks);
        return elseIfStatementCodeBlocks;
    }

    private List<String> _getIfStatementCodeBlock(String content, int x) {
        Matcher matcher = _ifStatementPattern.matcher(content);
        while (matcher.find()) {
            String s;
            int closeCurlyBracePos = this._getCloseCurlyBracePos(content, matcher.start());
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || closeCurlyBracePos > x || (s = StringUtil.trim(content.substring(0, matcher.start()))).endsWith("else")) continue;
            ArrayList<String> ifStatementCodeBlocks = new ArrayList<String>();
            ifStatementCodeBlocks.add(content.substring(matcher.start(), closeCurlyBracePos + 1));
            if (closeCurlyBracePos != x) {
                List<String> elseIfStatementCodeBlocks = this._getElseIfStatementCodeBlock(content, closeCurlyBracePos, x);
                if (elseIfStatementCodeBlocks.isEmpty()) continue;
                ifStatementCodeBlocks.addAll(elseIfStatementCodeBlocks);
            }
            return ifStatementCodeBlocks;
        }
        return null;
    }
}

