/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;

public class GradlePetraModuleDependenciesCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.contains("/modules/core/petra/")) {
            return content;
        }
        List<String> dependenciesBlocks = GradleSourceUtil.getDependenciesBlocks(content);
        for (String dependenciesBlock : dependenciesBlocks) {
            int y;
            int x = dependenciesBlock.indexOf("\n");
            if (x == (y = dependenciesBlock.lastIndexOf("\n"))) continue;
            String dependencies = dependenciesBlock.substring(x, y + 1);
            for (String line : StringUtil.splitLines(dependencies)) {
                if (!Validator.isNotNull(line) || line.contains("petra")) continue;
                this.addMessage(fileName, "Only modules/core/petra dependencies are allowed", SourceUtil.getLineNumber(content, content.indexOf(line)));
            }
        }
        return content;
    }
}

