/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FileStatefulCheck
public class RegexpCheck
extends AbstractCheck {
    public static final String MSG_ILLEGAL_REGEXP = "illegal.regexp";
    public static final String MSG_REQUIRED_REGEXP = "required.regexp";
    public static final String MSG_DUPLICATE_REGEXP = "duplicate.regexp";
    private static final int DEFAULT_DUPLICATE_LIMIT = -1;
    private static final int DEFAULT_ERROR_LIMIT = 100;
    private static final String ERROR_LIMIT_EXCEEDED_MESSAGE = "The error limit has been exceeded, the check is aborting, there may be more unreported errors.";
    private String message;
    private boolean ignoreComments;
    private boolean illegalPattern;
    private int errorLimit = 100;
    private int duplicateLimit;
    private boolean checkForDuplicates;
    private int matchCount;
    private int errorCount;
    private Pattern format = Pattern.compile("^$", 8);
    private Matcher matcher;

    public void setMessage(String message) {
        this.message = message;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void setIllegalPattern(boolean illegalPattern) {
        this.illegalPattern = illegalPattern;
    }

    public void setErrorLimit(int errorLimit) {
        this.errorLimit = errorLimit;
    }

    public void setDuplicateLimit(int duplicateLimit) {
        this.duplicateLimit = duplicateLimit;
        this.checkForDuplicates = duplicateLimit > -1;
    }

    public final void setFormat(Pattern pattern) {
        this.format = CommonUtil.createPattern(pattern.pattern(), 8);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.matcher = this.format.matcher(this.getFileContents().getText().getFullText());
        this.matchCount = 0;
        this.errorCount = 0;
        this.findMatch();
    }

    private void findMatch() {
        boolean foundMatch = this.matcher.find();
        if (foundMatch) {
            FileText text = this.getFileContents().getText();
            LineColumn start = text.lineColumn(this.matcher.start());
            int startLine = start.getLine();
            boolean ignore = this.isIgnore(startLine, text, start);
            if (!ignore) {
                ++this.matchCount;
                if (this.illegalPattern || this.checkForDuplicates && this.matchCount - 1 > this.duplicateLimit) {
                    ++this.errorCount;
                    this.logMessage(startLine);
                }
            }
            if (this.canContinueValidation(ignore)) {
                this.findMatch();
            }
        } else if (!this.illegalPattern && this.matchCount == 0) {
            this.logMessage(0);
        }
    }

    private boolean canContinueValidation(boolean ignore) {
        return this.errorCount <= this.errorLimit - 1 && (ignore || this.illegalPattern || this.checkForDuplicates);
    }

    private boolean isIgnore(int startLine, FileText text, LineColumn start) {
        LineColumn end = this.matcher.end() == 0 ? text.lineColumn(0) : text.lineColumn(this.matcher.end() - 1);
        boolean ignore = false;
        if (this.ignoreComments) {
            FileContents theFileContents = this.getFileContents();
            int startColumn = start.getColumn();
            int endLine = end.getLine();
            int endColumn = end.getColumn();
            ignore = theFileContents.hasIntersectionWithComment(startLine, startColumn, endLine, endColumn);
        }
        return ignore;
    }

    private void logMessage(int lineNumber) {
        String msg = this.message == null || this.message.isEmpty() ? this.format.pattern() : this.message;
        if (this.errorCount >= this.errorLimit) {
            msg = ERROR_LIMIT_EXCEEDED_MESSAGE + msg;
        }
        if (this.illegalPattern) {
            this.log(lineNumber, MSG_ILLEGAL_REGEXP, msg);
        } else if (lineNumber > 0) {
            this.log(lineNumber, MSG_DUPLICATE_REGEXP, msg);
        } else {
            this.log(lineNumber, MSG_REQUIRED_REGEXP, msg);
        }
    }
}

