/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLEchoMessageCheck
extends BaseFileCheck {
    private static final Pattern _echoMessagePattern = Pattern.compile("<echo (.(?!(/>|</)))*?message=.*?/>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".xml")) {
            return content;
        }
        Matcher matcher = _echoMessagePattern.matcher(content);
        while (matcher.find()) {
            this.addMessage(fileName, "Do not use self-closing tag for attribute \"message\" in \"<echo>\" tag", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

