/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;

public abstract class BaseUpgradeVelocityMigrationCheck
extends BaseFileCheck {
    protected static final String EXTENSION_FREEMARKER = ".ftl";
    protected static final String EXTENSION_VELOCITY = ".vm";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith(EXTENSION_VELOCITY)) {
            FileUtil.write(this._getFreeMarkerMigratedFile(fileName), this.migrateContent(this._getFreeMarkerMigratedContent(content, fileName)));
        }
        return content;
    }

    protected abstract String migrateContent(String var1);

    private String _getFreeMarkerMigratedContent(String content, String velocityFileName) throws IOException {
        File file = this._getFreeMarkerMigratedFile(velocityFileName);
        if (file.length() != 0L) {
            content = FileUtil.read(file);
        }
        return content;
    }

    private File _getFreeMarkerMigratedFile(String fileName) {
        int periodIndex = fileName.lastIndexOf(".");
        int slashIndex = fileName.lastIndexOf(File.separator);
        return new File(StringBundler.concat(fileName.substring(0, slashIndex), File.separator, "migrated", File.separator, fileName.substring(slashIndex + 1, periodIndex), EXTENSION_FREEMARKER));
    }
}

