/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiProperties;
import com.liferay.poshi.core.elements.DefinitionPoshiElement;
import com.liferay.poshi.core.elements.DescriptionPoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.StringUtil;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.dom4j.Node;

public interface PoshiNode<A extends Node, B extends PoshiNode<A, B>>
extends Node {
    public static final PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();

    public B clone(A var1);

    public B clone(String var1) throws PoshiScriptParserException;

    default public String getFileExtension() {
        PoshiNode parentPoshiNode = (PoshiNode)this.getParent();
        return parentPoshiNode.getFileExtension();
    }

    default public URL getFilePathURL() {
        PoshiNode parentPoshiNode = (PoshiNode)this.getParent();
        return parentPoshiNode.getFilePathURL();
    }

    public String getPoshiScript();

    default public int getPoshiScriptLineNumber() {
        PoshiElement parentPoshiElement = (PoshiElement)this.getParent();
        if (parentPoshiElement == null || this instanceof PoshiElementAttribute && parentPoshiElement instanceof DefinitionPoshiElement) {
            return 1;
        }
        List<PoshiNode<?, ?>> poshiNodes = parentPoshiElement.getPoshiNodes();
        PoshiNode<?, ?> previousPoshiNode = null;
        Iterator<PoshiNode<?, ?>> iterator = poshiNodes.iterator();
        while (iterator.hasNext()) {
            Matcher poshiScriptBlockMatcher;
            PoshiElement previousPoshiElement;
            PoshiNode<?, ?> poshiNode = iterator.next();
            if (poshiNode instanceof DescriptionPoshiElement) continue;
            if (!poshiNode.equals(this)) {
                previousPoshiNode = poshiNode;
                if (iterator.hasNext()) continue;
            }
            if (previousPoshiNode == null) {
                return parentPoshiElement.getPoshiScriptLineNumber() + StringUtil.countStartingNewLines(this.getPoshiScript());
            }
            int poshiScriptLineNumber = previousPoshiNode.getPoshiScriptLineNumber();
            String previousPoshiScript = previousPoshiNode.getPoshiScript();
            poshiScriptLineNumber = poshiScriptLineNumber - StringUtil.countStartingNewLines(previousPoshiScript) + StringUtil.count(previousPoshiScript, "\n");
            String poshiScript = poshiNode.getPoshiScript();
            if (!iterator.hasNext()) {
                poshiScript = this.getPoshiScript();
            }
            poshiScriptLineNumber += StringUtil.countStartingNewLines(poshiScript);
            if (previousPoshiNode instanceof PoshiElement && (previousPoshiElement = (PoshiElement)previousPoshiNode).getBlockName() != null && (poshiScriptBlockMatcher = PoshiElement.poshiScriptBlockPattern.matcher(previousPoshiScript)).find()) {
                int newLineCount = StringUtil.count(parentPoshiElement.getBlockName(previousPoshiScript), "\n");
                poshiScriptLineNumber -= newLineCount;
            }
            return poshiScriptLineNumber;
        }
        if (previousPoshiNode == null) {
            return parentPoshiElement.getPoshiScriptLineNumber() + StringUtil.countStartingNewLines(this.getPoshiScript());
        }
        return previousPoshiNode.getPoshiScriptLineNumber() + StringUtil.count(previousPoshiNode.getPoshiScript(), "\n");
    }

    default public boolean isValidPoshiXML() throws PoshiScriptParserException {
        PoshiNode parentPoshiNode = (PoshiNode)this.getParent();
        return parentPoshiNode.isValidPoshiXML();
    }

    public void parsePoshiScript(String var1) throws PoshiScriptParserException;

    public void setPoshiScript(String var1);

    public String toPoshiScript();

    default public void validatePoshiScript() throws PoshiScriptParserException {
        String originalPoshiScript = this.getPoshiScript();
        String generatedPoshiScript = this.toPoshiScript();
        if (!(originalPoshiScript = originalPoshiScript.replaceAll("\\s+", "")).equals(generatedPoshiScript = generatedPoshiScript.replaceAll("\\s+", ""))) {
            PoshiScriptParserException poshiScriptParserException = new PoshiScriptParserException("Poshi Script syntax is not preserved in translation", this);
            throw poshiScriptParserException;
        }
    }
}

