/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarFactoryUtil {
    public static Calendar getCalendar() {
        return new GregorianCalendar();
    }

    public static Calendar getCalendar(int year, int month, int date) {
        return new GregorianCalendar(year, month, date);
    }

    public static Calendar getCalendar(int year, int month, int date, int hour, int minute) {
        return new GregorianCalendar(year, month, date, hour, minute);
    }

    public static Calendar getCalendar(int year, int month, int date, int hour, int minute, int second) {
        return new GregorianCalendar(year, month, date, hour, minute, second);
    }

    public static Calendar getCalendar(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        return CalendarFactoryUtil.getCalendar(year, month, date, hour, minute, second, millisecond, TimeZoneUtil.getDefault());
    }

    public static Calendar getCalendar(int year, int month, int date, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public static Calendar getCalendar(Locale locale) {
        return new GregorianCalendar(locale);
    }

    public static Calendar getCalendar(long time) {
        return CalendarFactoryUtil.getCalendar(time, TimeZoneUtil.getDefault());
    }

    public static Calendar getCalendar(long time, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTimeInMillis(time);
        return calendar;
    }

    public static Calendar getCalendar(TimeZone timeZone) {
        return new GregorianCalendar(timeZone);
    }

    public static Calendar getCalendar(TimeZone timeZone, Locale locale) {
        return new GregorianCalendar(timeZone, locale);
    }
}

