/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLogLevelCheck
extends BaseFileCheck {
    private static final Pattern _logLevelPattern = Pattern.compile("\n(\t+)_log.(debug|error|info|trace|warn)\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.contains("Log")) {
            this._checkLogLevel(content, fileName);
        }
        return content;
    }

    private void _checkLogLevel(String content, String fileName) {
        Matcher matcher = _logLevelPattern.matcher(content);
        while (matcher.find()) {
            String s;
            char c;
            int pos = matcher.start();
            while ((c = content.charAt((pos = content.lastIndexOf("\n\t", pos - 1)) + 2)) == '\t') {
            }
            String codeBlock = content.substring(pos, matcher.start());
            if (!(codeBlock.contains(s = "_log.is" + StringUtil.upperCaseFirstLetter(matcher.group(2)) + "Enabled()") ^ !s.equals("_log.isErrorEnabled()"))) continue;
            int lineNumber = this.getLineNumber(content, matcher.start(1));
            if (codeBlock.contains(s)) {
                this.addMessage(fileName, "Do not use _log.isErrorEnabled()", lineNumber);
                continue;
            }
            this.addMessage(fileName, "Use " + s, lineNumber);
        }
    }
}

