/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.JSPImportsFormatter;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeImportsCheck
extends BaseFileCheck {
    private static final Pattern _ftlImportNamePattern = Pattern.compile("(?:findService|staticUtil)[(\\[]\"([^\\s\"]+)\"[)\\]]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!(fileName.endsWith(".java") || fileName.endsWith(".jsp") || fileName.endsWith(".ftl"))) {
            return content;
        }
        return this._fixImports(fileName, content);
    }

    private static List<String> _getImportNames(String fileName, String content) throws Exception {
        ArrayList<String> importNames = new ArrayList();
        if (fileName.endsWith(".java")) {
            JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
            importNames = javaClass.getImportNames();
        } else if (fileName.endsWith(".jsp")) {
            importNames = JSPImportsFormatter.getImportNames(content);
        } else {
            Matcher matcher = _ftlImportNamePattern.matcher(content);
            while (matcher.find()) {
                importNames.add(matcher.group(1));
            }
        }
        return importNames;
    }

    private static String _replaceVariables(String content, Map<String, String> variablesMap) {
        if (variablesMap.isEmpty()) {
            return content;
        }
        String newContent = StringUtil.replace(content, ArrayUtil.toStringArray(variablesMap.keySet()), ArrayUtil.toStringArray(variablesMap.values()), true);
        for (Map.Entry<String, String> entry : variablesMap.entrySet()) {
            String regex = StringBundler.concat("\\b([_a-z]\\w*)", entry.getKey(), "\\b");
            Pattern pattern = Pattern.compile(regex);
            Matcher variableMatcher = pattern.matcher(newContent);
            String newClassName = entry.getValue();
            if (!variableMatcher.find() || StringUtil.equals(variableMatcher.group(), StringUtil.lowerCaseFirstLetter(newClassName))) continue;
            newContent = newContent.replaceAll(regex, variableMatcher.group(1) + newClassName);
        }
        return newContent;
    }

    private synchronized String _fixImports(String fileName, String content) throws Exception {
        Map<String, String> importsMap = this._getMap("imports.txt");
        for (String importName : UpgradeImportsCheck._getImportNames(fileName, content)) {
            String newImportName = importsMap.get(importName);
            if (newImportName == null) continue;
            content = StringUtil.replace(content, importName, newImportName);
        }
        Map<String, String> variablesMap = this._getVariablesMap(importsMap);
        if (fileName.endsWith(".java")) {
            JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
            String newContent = javaClass.getContent();
            return StringUtil.replace(content, newContent, UpgradeImportsCheck._replaceVariables(newContent, variablesMap));
        }
        return UpgradeImportsCheck._replaceVariables(content, variablesMap);
    }

    private Map<String, String> _getMap(String fileName) throws Exception {
        String[] lines;
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("dependencies/" + fileName);
        if (inputStream == null) {
            return map;
        }
        for (String line : lines = StringUtil.splitLines(StringUtil.read(inputStream))) {
            int separatorIndex = line.indexOf("=");
            map.put(line.substring(0, separatorIndex), line.substring(separatorIndex + 1));
        }
        return map;
    }

    private Map<String, String> _getVariablesMap(Map<String, String> importsMap) {
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : importsMap.entrySet()) {
            String newClassName;
            String className = SourceFormatterUtil.getSimpleName(entry.getKey());
            if (className.equals(newClassName = SourceFormatterUtil.getSimpleName(entry.getValue()))) continue;
            variablesMap.put(className, newClassName);
            variablesMap.put(StringUtil.lowerCaseFirstLetter(className), StringUtil.lowerCaseFirstLetter(newClassName));
        }
        return variablesMap;
    }
}

