/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeAlterColumnCallsOrderCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.contains("/upgrade/")) {
            return content;
        }
        String packagePath = "";
        if (absolutePath.contains("/portal-impl/")) {
            packagePath = "portal-impl";
        } else {
            BNDSettings bndSettings = this.getBNDSettings(fileName);
            if (bndSettings == null) {
                return content;
            }
            String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
            packagePath = StringUtil.removeLast(bundleSymbolicName, ".service");
        }
        content = this._sortMethodCallsByTableAndColumnName(content, "alterTableAddColumn", packagePath);
        content = this._sortMethodCallsByTableAndColumnName(content, "UpgradeProcessFactory.alterColumnName", packagePath);
        content = this._sortMethodCallsByTableAndColumnName(content, "UpgradeProcessFactory.alterColumnType", packagePath);
        return content;
    }

    private String _sortMethodCallsByTableAndColumnName(String content, String methodName, String packagePath) throws IOException {
        Pattern pattern = Pattern.compile("\n(\t+" + methodName + "\\()");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String tableName2;
            String tableName1;
            String tablesSQLContent;
            File file;
            String tablesSQLFileLocation;
            String methodCall2;
            List<String> parameterNames2;
            int x;
            String followingContent;
            String methodCall1 = JavaSourceUtil.getMethodCall(content, matcher.start(1));
            List<String> parameterNames1 = JavaSourceUtil.getParameterNames(methodCall1);
            if (ListUtil.isEmpty(parameterNames1) || parameterNames1.size() != 3 || !(followingContent = content.substring(x = matcher.start(1) + methodCall1.length())).startsWith(",\n") && !followingContent.startsWith(";\n") || !(followingContent = followingContent.substring(2)).startsWith(matcher.group(1)) || ListUtil.isEmpty(parameterNames2 = JavaSourceUtil.getParameterNames(methodCall2 = JavaSourceUtil.getMethodCall(content, x + 2))) || parameterNames2.size() != 3) continue;
            this.populateModelInformations();
            Object[] modelInformation = this.getModelInformation(packagePath);
            if (modelInformation == null || Validator.isNull(tablesSQLFileLocation = (String)modelInformation[1]) || !(file = new File(tablesSQLFileLocation)).exists() || (tablesSQLContent = FileUtil.read(file)) == null || !(tableName1 = StringUtil.unquote(parameterNames1.get(0))).equals(tableName2 = StringUtil.unquote(parameterNames2.get(0)))) continue;
            int index1 = SourceUtil.getColumnIndex(tablesSQLContent, tableName1, StringUtil.unquote(parameterNames1.get(1)));
            int index2 = SourceUtil.getColumnIndex(tablesSQLContent, tableName1, StringUtil.unquote(parameterNames2.get(1)));
            if (index2 == -1 || index1 <= index2 && index1 != -1) continue;
            content = StringUtil.replaceFirst(content, methodCall2, methodCall1, matcher.start());
            return StringUtil.replaceFirst(content, methodCall1, methodCall2, matcher.start());
        }
        return content;
    }
}

