/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.parser;

public class ParseException
extends RuntimeException {
    private int line = -1;
    private int column = -1;
    private String sourceInfo;

    public ParseException(String message, int line, int column) {
        super(message);
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public String getMessage() {
        StringBuilder buffer = new StringBuilder(super.getMessage());
        if (this.line >= 0) {
            buffer.append(" @[").append(this.line);
            if (this.column >= 0) {
                buffer.append(',').append(this.column);
            }
            buffer.append(']');
        }
        if (this.sourceInfo != null) {
            buffer.append(" in ").append(this.sourceInfo);
        }
        return buffer.toString();
    }
}

