/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLongLinesCheck
extends BaseFileCheck {
    private static final String _LINE_LENGTH_EXCLUDES = "line.length.excludes";
    private static final Pattern _annotationPattern = Pattern.compile("\n\t*@(.+)\\(\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.endsWith("Table.java") && !absolutePath.endsWith("/Table.java")) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                if (line.matches("\\s*\\*.*") || this.getLineLength(line) <= this.getMaxLineLength()) continue;
                String trimmedLine = StringUtil.trimLeading(line);
                if (this.isExcludedPath(_LINE_LENGTH_EXCLUDES, absolutePath, lineNumber) || this._isAnnotationParameter(content, trimmedLine) || !trimmedLine.startsWith("//") && !line.contains("\"")) continue;
                this.addMessage(fileName, "> " + this.getMaxLineLength(), lineNumber);
            }
        }
        return content;
    }

    private boolean _isAnnotationParameter(String content, String line) {
        int x = -1;
        int y = -1;
        int z = -1;
        while ((x = line.indexOf(", ", x + 1)) != -1) {
            y = line.indexOf("(");
            z = line.lastIndexOf(")");
            if (y != -1 && z != -1 && x > y && z > x) break;
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            return false;
        }
        Matcher matcher = _annotationPattern.matcher(content);
        block1: while (matcher.find()) {
            x = matcher.end();
            while ((x = content.indexOf(")", x + 1)) != -1) {
                String annotationParameters = content.substring(matcher.end() - 2, x + 1);
                if (this.getLevel(annotationParameters) != 0) continue;
                if (!annotationParameters.contains(line)) continue block1;
                return true;
            }
        }
        return false;
    }
}

