/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaForLoopCheck
extends BaseJavaTermCheck {
    private static final int _COLLECTION_TYPE_ARRAY = 0;
    private static final int _COLLECTION_TYPE_LIST = 1;
    private static final Pattern _arrayPattern = Pattern.compile("\tfor \\(int (\\w+) = 0;\\s+(\\w+) < (\\w+)\\.length;\\s+(\\w+)\\+\\+\\) \\{\n");
    private static final Pattern _listPattern = Pattern.compile("\tfor \\(int (\\w+) = 0;\\s+(\\w+) < (\\w+)\\.size\\(\\);\\s+(\\w+)\\+\\+\\) \\{\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String javaTermContent = this._formatForLoop(javaTerm.getContent(), fileName, fileContent, 0, javaTerm.getLineNumber());
        return this._formatForLoop(javaTermContent, fileName, fileContent, 1, javaTerm.getLineNumber());
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private String _formatForLoop(String javaTermContent, String fileName, String fileContent, int type, int lineNumber) {
        Pattern pattern1 = this._getForLoopPattern(type);
        Matcher matcher1 = pattern1.matcher(javaTermContent);
        while (matcher1.find()) {
            int reassignVarCount;
            int retrieveFromCollectionCount;
            int varNameCount;
            Pattern pattern2;
            Matcher matcher2;
            String insideLoopContent;
            String countVarName = matcher1.group(1);
            if (!countVarName.equals(matcher1.group(2)) || !countVarName.equals(matcher1.group(4)) || (insideLoopContent = this._getInsideLoopContent(javaTermContent, matcher1.end())) == null) continue;
            String collectionVarName = matcher1.group(3);
            if (type == 1 && !(matcher2 = (pattern2 = Pattern.compile(">\\s+" + collectionVarName + "\\W")).matcher(fileContent)).find() || insideLoopContent.matches("(?s).*\\." + collectionVarName + "\\W.*") || (varNameCount = this._getOccurenceCount(insideLoopContent, "\\W" + countVarName + "\\W", new String[0])) == 0 || varNameCount != (retrieveFromCollectionCount = this._getOccurenceCount(insideLoopContent, this._getRetrieveFromCollectionRegex(countVarName, collectionVarName, type), new String[0])) || type == 0 && (reassignVarCount = this._getOccurenceCount(insideLoopContent, StringBundler.concat("\\W", collectionVarName, "\\[", countVarName, "\\](\\s+[+-]?\\=\\s|--|\\+\\+)"), new String[0])) > 0) continue;
            Pattern pattern22 = Pattern.compile(this._getAssignVarRegex(countVarName, collectionVarName, type));
            Matcher matcher22 = pattern22.matcher(insideLoopContent);
            if (!matcher22.find() || varNameCount > 1) {
                this.addMessage(fileName, "Use Enhanced For-Loop", lineNumber - 1 + this.getLineNumber(javaTermContent, matcher1.start()));
                continue;
            }
            StringBundler sb = new StringBundler(7);
            sb.append("\tfor (");
            sb.append(matcher22.group(1));
            sb.append(" ");
            sb.append(matcher22.group(2));
            sb.append(" : ");
            sb.append(collectionVarName);
            sb.append(") {\n");
            javaTermContent = StringUtil.replaceFirst(javaTermContent, matcher1.group(), sb.toString(), matcher1.start());
            javaTermContent = StringUtil.replaceFirst(javaTermContent, matcher22.group(), "", matcher1.start());
            return javaTermContent;
        }
        return javaTermContent;
    }

    private String _getAssignVarRegex(String countVarName, String collectionVarName, int type) {
        if (type == 0) {
            return StringBundler.concat("\t+(\\w[\\w\\s\\[\\]<>,\\.\\?]*)\\s+(\\w+)\\s+=\\s+", collectionVarName, "\\[", countVarName, "\\];\n");
        }
        return StringBundler.concat("\t+(\\w[\\w\\s\\[\\]<>,\\.\\?]*)\\s+(\\w+)\\s+=\\s+", collectionVarName, "\\.get\\(", countVarName, "\\);\n");
    }

    private Pattern _getForLoopPattern(int type) {
        if (type == 0) {
            return _arrayPattern;
        }
        return _listPattern;
    }

    private String _getInsideLoopContent(String s, int x) {
        String insideLoopContent;
        int y = x;
        do {
            if ((y = s.indexOf("}", y + 1)) != -1) continue;
            return null;
        } while (ToolsUtil.isInsideQuotes(s, y) || this.getLevel(insideLoopContent = s.substring(x, y), "{", "}") != 0);
        return insideLoopContent;
    }

    private int _getOccurenceCount(String s, String regex, String ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            regex = StringUtil.replace(regex, "{" + i + "}", argument);
        }
        int count = 0;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    private String _getRetrieveFromCollectionRegex(String countVarName, String collectionVarName, int type) {
        if (type == 0) {
            return StringBundler.concat("\\W", collectionVarName, "\\s*\\[", countVarName, "\\]");
        }
        return StringBundler.concat("\\W", collectionVarName, "\\.\\s*get\\(\\s*", countVarName, "\\)");
    }
}

