/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class AnnotationLocationCheck
extends AbstractCheck {
    public static final String MSG_KEY_ANNOTATION_LOCATION_ALONE = "annotation.location.alone";
    public static final String MSG_KEY_ANNOTATION_LOCATION = "annotation.location";
    private boolean allowSamelineSingleParameterlessAnnotation = true;
    private boolean allowSamelineParameterizedAnnotation;
    private boolean allowSamelineMultipleAnnotations;

    public final void setAllowSamelineSingleParameterlessAnnotation(boolean allow) {
        this.allowSamelineSingleParameterlessAnnotation = allow;
    }

    public final void setAllowSamelineParameterizedAnnotation(boolean allow) {
        this.allowSamelineParameterizedAnnotation = allow;
    }

    public final void setAllowSamelineMultipleAnnotations(boolean allow) {
        this.allowSamelineMultipleAnnotations = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 16, 155, 154, 9, 8, 10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 16, 155, 154, 9, 8, 10, 157, 161};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() != 10 || ast.getParent().getType() == 6) {
            DetailAST node = ast.findFirstToken(5);
            if (node == null) {
                node = ast.findFirstToken(158);
            }
            this.checkAnnotations(node, AnnotationLocationCheck.getExpectedAnnotationIndentation(node));
        }
    }

    private static int getExpectedAnnotationIndentation(DetailAST node) {
        return node.getColumnNo();
    }

    private void checkAnnotations(DetailAST modifierNode, int correctIndentation) {
        for (DetailAST annotation = modifierNode.getFirstChild(); annotation != null && annotation.getType() == 159; annotation = annotation.getNextSibling()) {
            boolean hasParameters = AnnotationLocationCheck.isParameterized(annotation);
            if (!this.isCorrectLocation(annotation, hasParameters)) {
                this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_LOCATION_ALONE, AnnotationLocationCheck.getAnnotationName(annotation));
                continue;
            }
            if (annotation.getColumnNo() == correctIndentation || AnnotationLocationCheck.hasNodeBefore(annotation)) continue;
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_LOCATION, AnnotationLocationCheck.getAnnotationName(annotation), annotation.getColumnNo(), correctIndentation);
        }
    }

    private static boolean isParameterized(DetailAST annotation) {
        return TokenUtil.findFirstTokenByPredicate(annotation, ast -> ast.getType() == 28 || ast.getType() == 160).isPresent();
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST identNode = annotation.findFirstToken(58);
        if (identNode == null) {
            identNode = annotation.findFirstToken(59).findFirstToken(58);
        }
        return identNode.getText();
    }

    private boolean isCorrectLocation(DetailAST annotation, boolean hasParams) {
        boolean allowingCondition = hasParams ? this.allowSamelineParameterizedAnnotation : this.allowSamelineSingleParameterlessAnnotation;
        return this.allowSamelineMultipleAnnotations || allowingCondition && !AnnotationLocationCheck.hasNodeBefore(annotation) || !AnnotationLocationCheck.hasNodeBeside(annotation);
    }

    private static boolean hasNodeBefore(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST previousNode = annotation.getPreviousSibling();
        return previousNode != null && annotationLineNo == previousNode.getLineNo();
    }

    private static boolean hasNodeBeside(DetailAST annotation) {
        return AnnotationLocationCheck.hasNodeBefore(annotation) || AnnotationLocationCheck.hasNodeAfter(annotation);
    }

    private static boolean hasNodeAfter(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST nextNode = annotation.getNextSibling();
        if (nextNode == null) {
            nextNode = annotation.getParent().getNextSibling();
        }
        return annotationLineNo == nextNode.getLineNo();
    }
}

