/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;

public class PropertiesPortletFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("/portlet.properties")) {
            return this._formatPortletProperties(fileName, content);
        }
        return content;
    }

    private String _formatPortletProperties(String fileName, String content) throws IOException {
        if (!content.contains("include-and-override=portlet-ext.properties")) {
            content = "include-and-override=portlet-ext.properties\n\n" + content;
        }
        if (!this.isPortalSource() && !this.isSubrepository()) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            String previousProperty = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos;
                if (++lineNumber == 1 || line.startsWith("#") || line.startsWith(" ") || line.startsWith("\t") || (pos = line.indexOf(61)) == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos));
                if ((pos = property.indexOf(91)) != -1) {
                    property = property.substring(0, pos);
                }
                if (Validator.isNotNull(previousProperty) && previousProperty.compareToIgnoreCase(property) > 0) {
                    this.addMessage(fileName, "Unsorted property \"" + property + "\"", lineNumber);
                }
                previousProperty = property;
            }
        }
        return content;
    }
}

