/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiProperties;
import com.liferay.poshi.core.elements.AndPoshiElement;
import com.liferay.poshi.core.elements.CommandPoshiElement;
import com.liferay.poshi.core.elements.DescriptionPoshiElement;
import com.liferay.poshi.core.elements.ElseIfPoshiElement;
import com.liferay.poshi.core.elements.ElsePoshiElement;
import com.liferay.poshi.core.elements.ExecutePoshiElement;
import com.liferay.poshi.core.elements.IfPoshiElement;
import com.liferay.poshi.core.elements.InlinePoshiComment;
import com.liferay.poshi.core.elements.NotPoshiElement;
import com.liferay.poshi.core.elements.OrPoshiElement;
import com.liferay.poshi.core.elements.PoshiCDATA;
import com.liferay.poshi.core.elements.PoshiComment;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.PropertyPoshiElement;
import com.liferay.poshi.core.elements.VarPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.script.PoshiScriptParserUtil;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.NaturalOrderStringComparator;
import com.liferay.poshi.core.util.RegexUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;

public abstract class PoshiElement
extends DefaultElement
implements PoshiNode<Element, PoshiElement> {
    protected static final String ASSIGNMENT_REGEX = "[\\s]*=[\\s]*";
    protected static final String BLOCK_NAME_ANNOTATION_REGEX = "(@.*=.*|)";
    protected static final String BLOCK_NAME_PARAMETER_REGEX = "[\\s]*\\(.*?\\)$";
    protected static final String INVOCATION_REGEX;
    protected static final String INVOCATION_START_REGEX = "[\\s]*[\\w\\.]*";
    protected static final String NONQUOTED_REGEX = "(\\$\\{.*\\}|\\d+)";
    protected static final String PARAMETER_REGEX = "\\((.*?|.*)\\)";
    protected static final String QUOTED_REGEX = "\".*\"";
    protected static final String STATEMENT_END_REGEX = ";$";
    protected static final String VAR_NAME_REGEX = "((static[\\s]*|)var|)([\\s]*[A-Z][\\w]*|)[\\s]*[\\w]*";
    protected static final String VAR_STATEMENT_END_REGEX = "(;|)$";
    protected static final Pattern poshiScriptAnnotationPattern;
    protected static final Pattern poshiScriptBlockPattern;
    protected static final Pattern varInvocationAssignmentStatementPattern;
    private static final Pattern _nestedConditionPattern;
    private static final Pattern _poshiScriptCommentPattern;
    private static final Pattern _varNamePattern;
    private String _poshiScript;

    public PoshiElement(String name) {
        super(name);
    }

    public void add(Attribute attribute) {
        if (attribute instanceof PoshiElementAttribute) {
            super.add(attribute);
            return;
        }
        super.add((Attribute)new PoshiElementAttribute(attribute));
    }

    public void add(CDATA cdata) {
        if (cdata instanceof PoshiCDATA) {
            super.add(cdata);
            return;
        }
        super.add((CDATA)new PoshiCDATA(cdata));
    }

    public abstract PoshiElement clone(PoshiElement var1, String var2) throws PoshiScriptParserException;

    @Override
    public PoshiElement clone(String poshiScript) throws PoshiScriptParserException {
        return this.clone(null, poshiScript);
    }

    public String getPoshiLogDescriptor() {
        return this.getPoshiScript();
    }

    @Override
    public String getPoshiScript() {
        return this._poshiScript;
    }

    public int getPoshiScriptLineNumber(Boolean includeAnnotation) {
        int poshiScriptLineNumber = PoshiNode.super.getPoshiScriptLineNumber();
        if (!includeAnnotation.booleanValue()) {
            poshiScriptLineNumber += StringUtil.count(this.getBlockName(this.getPoshiScript()), "\n");
        }
        return poshiScriptLineNumber;
    }

    public boolean isPoshiScriptComment(String poshiScript) {
        Matcher matcher = _poshiScriptCommentPattern.matcher(poshiScript);
        return matcher.find();
    }

    public boolean isValidPoshiScript() throws PoshiScriptParserException {
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributeList())) {
            poshiElementAttribute.validatePoshiScript();
        }
        String originalPoshiScript = this.getPoshiScript();
        String generatedPoshiScript = this.toPoshiScript();
        originalPoshiScript = originalPoshiScript.replaceAll("\\s+", "");
        generatedPoshiScript = generatedPoshiScript.replaceAll("\\s+", "");
        return (this.elements().size() != 0 || originalPoshiScript.equals(generatedPoshiScript)) && originalPoshiScript.length() == generatedPoshiScript.length();
    }

    public boolean remove(Attribute attribute) {
        if (attribute instanceof PoshiElementAttribute) {
            return super.remove(attribute);
        }
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributes())) {
            if (poshiElementAttribute != attribute) continue;
            return super.remove((Attribute)poshiElementAttribute);
        }
        return false;
    }

    public boolean remove(CDATA cdata) {
        if (cdata instanceof PoshiCDATA) {
            return super.remove(cdata);
        }
        for (PoshiNode<?, ?> poshiNode : this.toPoshiNodes(this.content())) {
            if (poshiNode != cdata) continue;
            return super.remove(poshiNode);
        }
        return false;
    }

    public void setFilePathURL(URL filePathURL) {
    }

    @Override
    public void setPoshiScript(String poshiScript) {
        this._poshiScript = poshiScript;
    }

    public List<PoshiElement> toPoshiElements(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PoshiElement> poshiElements = new ArrayList<PoshiElement>(list.size());
        for (Object object : list) {
            poshiElements.add((PoshiElement)object);
        }
        return poshiElements;
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        for (Node node : Dom4JUtil.toNodeList(this.content())) {
            if (node instanceof PoshiComment) {
                PoshiComment poshiComment = (PoshiComment)node;
                sb.append(poshiComment.toPoshiScript());
                continue;
            }
            if (!(node instanceof PoshiElement)) continue;
            PoshiElement poshiElement = (PoshiElement)node;
            sb.append(poshiElement.toPoshiScript());
        }
        return sb.toString();
    }

    @Override
    public void validatePoshiScript() throws PoshiScriptParserException {
        if (!this.isValidPoshiScript() && !this.isValidPoshiXML()) {
            throw new PoshiScriptParserException("Poshi Script syntax is not preserved in translation", this);
        }
    }

    protected PoshiElement(String name, Element element) {
        super(name);
        if (!this.isElementType(name, element)) {
            throw new RuntimeException("Element does not match expected Poshi element name\n" + element.toString());
        }
        this._addAttributes(element);
        this._addNodes(element);
    }

    protected PoshiElement(String name, Element element, URL url) {
        this(name, element);
        this.setFilePathURL(url);
    }

    protected PoshiElement(String name, List<Attribute> attributes, List<Node> nodes) {
        super(name);
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.add(attribute);
            }
        }
        if (nodes != null) {
            for (Node node : nodes) {
                this.add(node);
            }
        }
    }

    protected PoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        this(name, parentPoshiElement, poshiScript, null);
    }

    protected PoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript, URL url) throws PoshiScriptParserException {
        super(name);
        this.setFilePathURL(url);
        this.setParent((Element)parentPoshiElement);
        this.setPoshiScript(poshiScript);
        try {
            this.parsePoshiScript(poshiScript.trim());
            if (PoshiElement.poshiProperties.testPoshiScriptValidation && !PoshiNodeFactory.validationInitialized.contains(this.getFilePathURL())) {
                PoshiNodeFactory.validationInitialized.add(this.getFilePathURL());
                this.validatePoshiScript();
            }
        }
        catch (PoshiScriptParserException poshiScriptParserException) {
            // empty catch block
        }
        this.detach();
    }

    protected String createPoshiScriptBlock(List<PoshiNode<?, ?>> poshiNodes) {
        StringBuilder sb = new StringBuilder();
        String pad = this.getPad();
        sb.append("\n");
        sb.append(pad);
        String blockName = this.getBlockName();
        sb.append(blockName);
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        if (poshiProperties.generateCommandSignature.booleanValue() && (blockName.startsWith("function") || blockName.startsWith("macro"))) {
            sb.append("(");
            if (Validator.isNotNull(this.attributeValue("arguments"))) {
                sb.append(this.attributeValue("arguments"));
            }
            sb.append(")");
        }
        sb.append(" {");
        PoshiNode<?, ?> previousPoshiNode = null;
        Collections.sort(poshiNodes, new CommandComparator());
        Collections.sort(poshiNodes, new PropertyComparator());
        for (PoshiNode<?, ?> poshiNode : poshiNodes) {
            if (poshiNode instanceof DescriptionPoshiElement) continue;
            String poshiScriptSnippet = poshiNode.toPoshiScript();
            if ((previousPoshiNode == null || previousPoshiNode instanceof PropertyPoshiElement && poshiNode instanceof PropertyPoshiElement || previousPoshiNode instanceof InlinePoshiComment && poshiNode instanceof InlinePoshiComment) && poshiScriptSnippet.startsWith("\n\n")) {
                poshiScriptSnippet = poshiScriptSnippet.replaceFirst("\n\n", "\n");
            }
            String padPoshiScriptSnippet = this.padPoshiScriptSnippet(poshiScriptSnippet);
            if ((padPoshiScriptSnippet = this._removeEmptyLineBetweenVariables(padPoshiScriptSnippet, poshiNode, previousPoshiNode)).startsWith("\n\n") && StringUtil.endsWith(sb.toString(), "{")) {
                padPoshiScriptSnippet = padPoshiScriptSnippet.replaceFirst("\n\n", "\n");
            }
            if (previousPoshiNode == null && poshiNode instanceof InlinePoshiComment) {
                padPoshiScriptSnippet = "\n" + padPoshiScriptSnippet;
            }
            if (StringUtil.endsWith(sb.toString(), "\ndefinition {") && !padPoshiScriptSnippet.startsWith("\n\n")) {
                sb.append("\n");
            }
            sb.append(padPoshiScriptSnippet);
            previousPoshiNode = poshiNode;
        }
        if (previousPoshiNode instanceof InlinePoshiComment) {
            sb.append("\n");
        }
        sb.append("\n");
        if (blockName.equals("definition")) {
            sb.append("\n");
        }
        sb.append(pad);
        sb.append("}");
        return sb.toString();
    }

    protected String createPoshiScriptSnippet(String content) {
        StringBuilder sb = new StringBuilder();
        String pad = this.getPad();
        sb.append("\n");
        sb.append(pad);
        sb.append(this.getBlockName());
        sb.append(" {");
        if (content.startsWith("\n\n")) {
            content = content.replaceFirst("\n\n", "\n");
        }
        content = content.replaceAll("\n", "\n" + pad);
        sb.append(content.replaceAll("\n\t\n", "\n\n"));
        sb.append("\n");
        sb.append(pad);
        sb.append("}");
        return sb.toString();
    }

    protected String doubleQuoteContent(String content) {
        return "\"" + content + "\"";
    }

    protected String getBlockContent(String poshiScriptBlock) {
        String blockName = this.getBlockName(poshiScriptBlock);
        int index = blockName.length();
        String blockContent = poshiScriptBlock.substring(index);
        return this.getBracedContent(blockContent);
    }

    protected abstract String getBlockName();

    protected String getBlockName(String poshiScriptBlock) {
        StringBuilder sb = new StringBuilder();
        for (char c : poshiScriptBlock.toCharArray()) {
            if (c == '{' && PoshiScriptParserUtil.isBalancedPoshiScript(sb.toString())) {
                String blockName = sb.toString();
                return blockName.trim();
            }
            sb.append(c);
        }
        throw new RuntimeException("Unable to get Poshi script block name from:\n" + poshiScriptBlock);
    }

    protected String getBracedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\\{(.*)\\}", 1);
    }

    protected String getBracketedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\\[(.*)\\]", 1);
    }

    protected String getClassCommandName(String classCommand) {
        if ((classCommand = classCommand.trim()).contains("(")) {
            int index = classCommand.indexOf("(");
            classCommand = classCommand.substring(0, index);
        }
        return classCommand;
    }

    protected String getClassName(String classCommand) {
        String classCommandName = this.getClassCommandName(classCommand);
        int index = classCommandName.length();
        if (classCommandName.contains(".")) {
            index = classCommandName.lastIndexOf(".");
        } else if (classCommandName.contains("#")) {
            index = classCommandName.lastIndexOf("#");
        }
        return classCommandName.substring(0, index);
    }

    protected String getCommandName(String classCommand) {
        String classCommandName = this.getClassCommandName(classCommand);
        if (classCommandName.contains(".")) {
            int index = classCommandName.lastIndexOf(".");
            return classCommandName.substring(index + 1);
        }
        return classCommandName;
    }

    protected Pattern getConditionPattern() {
        return null;
    }

    protected String getDoubleQuotedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\"(.*)\"", 1);
    }

    protected String getNameFromAssignment(String assignment) {
        String name = assignment.split("=")[0];
        name = name.trim();
        name = StringUtil.replace(name, "@", "");
        name = StringUtil.replace(name, "property ", "");
        return StringUtil.replace(name, "var ", "");
    }

    protected List<String> getNestedConditions(String poshiScript, String operator) {
        ArrayList<String> nestedConditions = new ArrayList<String>();
        TreeSet<Integer> tokenIndices = new TreeSet<Integer>();
        int index = poshiScript.indexOf(operator);
        while (index >= 0) {
            tokenIndices.add(index);
            index = poshiScript.indexOf(operator, index + 1);
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = poshiScript.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (tokenIndices.contains(i) && PoshiScriptParserUtil.isBalancedPoshiScript(sb.toString())) {
                nestedConditions.add(sb.toString());
                sb.setLength(0);
                ++i;
                continue;
            }
            if (i == chars.length - 1) {
                String nestedCondition;
                sb.append(c);
                if (PoshiScriptParserUtil.isBalancedPoshiScript(sb.toString()) && !nestedConditions.isEmpty() && !(nestedCondition = sb.toString()).contains("maxIterations")) {
                    nestedConditions.add(nestedCondition);
                }
            }
            sb.append(c);
        }
        return nestedConditions;
    }

    protected String getPad() {
        return "\t";
    }

    protected String getParentheticalContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?\\((.*)\\)", 1);
    }

    protected List<PoshiNode<?, ?>> getPoshiNodes() {
        return this.toPoshiNodes(this.content());
    }

    protected String getPoshiScriptEscapedContent(String poshiScript) {
        poshiScript = poshiScript.trim();
        return poshiScript.substring(3, poshiScript.length() - 3);
    }

    protected String getPoshiScriptKeyword() {
        PoshiElement poshiParentElement = (PoshiElement)this.getParent();
        return poshiParentElement.getPoshiScriptKeyword();
    }

    protected List<String> getPoshiScriptSnippets(String poshiScriptBlockContent) {
        return this.getPoshiScriptSnippets(poshiScriptBlockContent, true);
    }

    protected List<String> getPoshiScriptSnippets(String poshiScriptBlockContent, boolean splitElseBlocks) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> poshiScriptSnippets = new ArrayList<String>();
        int index = 0;
        boolean skipBalanceCheck = false;
        Stack<Integer> storedIndices = new Stack<Integer>();
        for (char c : poshiScriptBlockContent.toCharArray()) {
            sb.append(c);
            String poshiScriptSnippet = sb.toString();
            String trimmedPoshiScriptSnippet = poshiScriptSnippet.trim();
            if (trimmedPoshiScriptSnippet.startsWith("//")) {
                if (c != '\n') continue;
                poshiScriptSnippet = poshiScriptSnippet.substring(0, poshiScriptSnippet.length() - 1);
                poshiScriptSnippets.add(poshiScriptSnippet);
                sb.setLength(0);
                sb.append(c);
                continue;
            }
            if (trimmedPoshiScriptSnippet.startsWith("/*")) {
                if (!trimmedPoshiScriptSnippet.endsWith("*/")) continue;
                poshiScriptSnippets.add(poshiScriptSnippet);
                sb.setLength(0);
                continue;
            }
            ++index;
            if (c == '\'') {
                if (storedIndices.isEmpty()) {
                    storedIndices.push(index);
                } else if ((Integer)storedIndices.peek() == index - 1) {
                    storedIndices.push(index);
                }
                if (storedIndices.size() == 3 || storedIndices.size() == 6) {
                    boolean bl = skipBalanceCheck = !skipBalanceCheck;
                }
                if (storedIndices.size() > 6) {
                    throw new RuntimeException("Invalid multiline string: \n" + poshiScriptSnippet);
                }
            } else {
                storedIndices.clear();
            }
            if (trimmedPoshiScriptSnippet.startsWith("return") && c != ';' || skipBalanceCheck || c != '}' && c != ';' || this._isVarPoshiScriptSnippet(trimmedPoshiScriptSnippet) && c != ';' || !PoshiScriptParserUtil.isBalancedPoshiScript(poshiScriptSnippet)) continue;
            if (splitElseBlocks && (this.isValidPoshiScriptBlock(ElseIfPoshiElement.blockNamePattern, poshiScriptSnippet) || this.isValidPoshiScriptBlock(ElsePoshiElement.blockNamePattern, poshiScriptSnippet))) {
                int lastIndex = poshiScriptSnippets.size() - 1;
                String lastPoshiScriptSnippet = (String)poshiScriptSnippets.get(lastIndex);
                poshiScriptSnippets.set(lastIndex, lastPoshiScriptSnippet + poshiScriptSnippet);
                sb.setLength(0);
                continue;
            }
            poshiScriptSnippets.add(poshiScriptSnippet);
            sb.setLength(0);
        }
        String poshiScriptSnippet = sb.toString();
        if (!(poshiScriptSnippet = poshiScriptSnippet.trim()).isEmpty()) {
            poshiScriptSnippets.add(poshiScriptSnippet);
        }
        return poshiScriptSnippets;
    }

    protected String getSingleQuotedContent(String poshiScript) {
        return RegexUtil.getGroup(poshiScript, ".*?'(.*)'", 1);
    }

    protected Pattern getStatementPattern() {
        return null;
    }

    protected String getValueFromAssignment(String assignment) {
        assignment = assignment.trim();
        int start = assignment.indexOf("=");
        int end = assignment.length();
        if (assignment.endsWith(";")) {
            --end;
        }
        String value = assignment.substring(start + 1, end);
        return value.trim();
    }

    protected final boolean isConditionElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (!this.isConditionValidInParent(parentPoshiElement)) {
            return false;
        }
        poshiScript = poshiScript.trim();
        Pattern conditionPattern = this.getConditionPattern();
        if (conditionPattern == null) {
            throw new RuntimeException("Condition pattern has not been defined");
        }
        Matcher matcher = conditionPattern.matcher(poshiScript);
        return matcher.find();
    }

    protected boolean isConditionValidInParent(PoshiElement parentPoshiElement) {
        return parentPoshiElement instanceof AndPoshiElement || parentPoshiElement instanceof ElseIfPoshiElement || parentPoshiElement instanceof IfPoshiElement || parentPoshiElement instanceof NotPoshiElement || parentPoshiElement instanceof OrPoshiElement;
    }

    protected boolean isElementType(String name, Element element) {
        return name.equals(element.getName());
    }

    protected boolean isNestedCondition(String poshiScript) {
        List<String> nestedConditions;
        Matcher matcher = _nestedConditionPattern.matcher(poshiScript);
        return matcher.find() && (nestedConditions = this.getNestedConditions(poshiScript, matcher.group(0))).size() > 1;
    }

    protected boolean isQuotedContent(String content) {
        if (content.matches(NONQUOTED_REGEX)) {
            if (content.contains("{")) {
                return !this.isSingleVariable(content);
            }
            return false;
        }
        return true;
    }

    protected boolean isSingleVariable(String content) {
        boolean singleVariable = false;
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < content.length(); ++i) {
            char previousChar;
            char c = content.charAt(i);
            if (i > 0 && (previousChar = content.charAt(i - 1)) == '$' && c == '{') {
                stack.push(Character.valueOf(c));
            }
            if (stack.isEmpty() || c != '}') continue;
            stack.pop();
            if (i != content.length() - 1) break;
            singleVariable = true;
            break;
        }
        return singleVariable;
    }

    protected boolean isValidFunctionFileName(String poshiScriptInvocation) {
        poshiScriptInvocation = poshiScriptInvocation.trim();
        Set<String> functionFileNames = PoshiContext.getFunctionFileNames();
        return functionFileNames.contains(this.getClassName(poshiScriptInvocation)) || functionFileNames.contains(this.getClassCommandName(poshiScriptInvocation));
    }

    protected boolean isValidMacroFileName(String poshiScriptInvocation) {
        Set<String> macroFileNames;
        if ((poshiScriptInvocation = poshiScriptInvocation.trim()).startsWith("var ")) {
            poshiScriptInvocation = this.getValueFromAssignment(poshiScriptInvocation);
        }
        return (macroFileNames = PoshiContext.getMacroFileNames()).contains(this.getClassName(poshiScriptInvocation)) || macroFileNames.contains(this.getClassCommandName(poshiScriptInvocation));
    }

    protected boolean isValidPoshiScriptBlock(Pattern poshiScriptBlockNamePattern, String poshiScript) {
        Matcher poshiScriptBlockNameMatcher;
        Matcher poshiScriptBlockMatcher = poshiScriptBlockPattern.matcher(poshiScript = poshiScript.trim());
        return poshiScriptBlockMatcher.find() && (poshiScriptBlockNameMatcher = poshiScriptBlockNamePattern.matcher(this.getBlockName(poshiScript))).find();
    }

    protected boolean isValidPoshiScriptStatement(Pattern poshiScriptStatementPattern, String poshiScript) {
        Matcher poshiScriptStatementMatcher = poshiScriptStatementPattern.matcher(poshiScript = poshiScript.trim());
        return poshiScriptStatementMatcher.find();
    }

    protected boolean isVarAssignedToMacroInvocation(String poshiScript) {
        if (!(poshiScript = poshiScript.trim()).startsWith("var")) {
            return false;
        }
        String value = this.getValueFromAssignment(poshiScript);
        return this.isValidPoshiScriptStatement(varInvocationAssignmentStatementPattern, poshiScript) && this.isValidMacroFileName(value);
    }

    protected String padPoshiScriptSnippet(String poshiScriptSnippet) {
        if (!(poshiScriptSnippet.contains("'''") || poshiScriptSnippet.contains("/*") || poshiScriptSnippet.contains("*/"))) {
            poshiScriptSnippet = StringUtil.replace(poshiScriptSnippet, "\n", "\n" + this.getPad());
            poshiScriptSnippet = StringUtil.replace(poshiScriptSnippet, "\n\t\n", "\n\n");
            return StringUtil.replace(poshiScriptSnippet, "\n\n\n", "\n\n");
        }
        Stack<String> stack = new Stack<String>();
        StringBuilder sb = new StringBuilder();
        if (poshiScriptSnippet.startsWith("\n\n")) {
            poshiScriptSnippet = poshiScriptSnippet.replaceFirst("\n\n", "\n");
        }
        for (String line : poshiScriptSnippet.split("\n")) {
            String trimmedLine = line.trim();
            sb.append("\n");
            String stackPeek = "";
            if (stack.isEmpty()) {
                if (!trimmedLine.isEmpty()) {
                    line = this.getPad() + line;
                }
            } else {
                stackPeek = (String)stack.peek();
            }
            sb.append(line);
            if (trimmedLine.startsWith("/*") && !stack.contains("/*")) {
                stack.push("/*");
            }
            if (StringUtil.count(trimmedLine, "'''") % 2 == 1) {
                if (stackPeek.equals("'''")) {
                    stack.pop();
                } else {
                    stack.push("'''");
                }
            }
            if (!trimmedLine.endsWith("*/") || !stackPeek.equals("/*")) continue;
            stack.pop();
        }
        return sb.toString();
    }

    protected String singleQuoteContent(String content) {
        return "'" + content + "'";
    }

    protected List<PoshiElementAttribute> toPoshiElementAttributes(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PoshiElementAttribute> poshiElementAttributes = new ArrayList<PoshiElementAttribute>(list.size());
        for (Object object : list) {
            poshiElementAttributes.add((PoshiElementAttribute)object);
        }
        return poshiElementAttributes;
    }

    protected List<PoshiNode<?, ?>> toPoshiNodes(List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList poshiNodes = new ArrayList(list.size());
        for (Object object : list) {
            poshiNodes.add((PoshiNode)object);
        }
        return poshiNodes;
    }

    protected void validateSemicolon(String poshiScript) throws PoshiScriptParserException {
        int i;
        int index = 0;
        Pattern statementPattern = this.getStatementPattern();
        Matcher matcher = statementPattern.matcher(poshiScript = poshiScript.trim());
        if (matcher.find()) {
            if (matcher.end() == poshiScript.length()) {
                index = matcher.end();
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(matcher.group());
                for (i = matcher.end(); i < poshiScript.length(); ++i) {
                    sb.append(poshiScript.charAt(i));
                    String balanced = sb.toString();
                    matcher = statementPattern.matcher(balanced);
                    if (!PoshiScriptParserUtil.isBalancedPoshiScript(balanced) || !matcher.find()) continue;
                    index = i + 1;
                    break;
                }
            }
        }
        String errorMessage = "Missing semicolon";
        for (i = index; i < poshiScript.length(); ++i) {
            char c = poshiScript.charAt(i);
            if (Character.isWhitespace(c) || c == ';') continue;
            throw new PoshiScriptParserException(errorMessage, poshiScript, (PoshiElement)this.getParent());
        }
        if (!poshiScript.endsWith(";")) {
            throw new PoshiScriptParserException(errorMessage, poshiScript, (PoshiElement)this.getParent());
        }
    }

    private void _addAttributes(Element element) {
        for (Attribute attribute : Dom4JUtil.toAttributeList(element.attributes())) {
            this.add((Attribute)new PoshiElementAttribute((Attribute)attribute.clone()));
        }
    }

    private void _addNodes(Element element) {
        for (Node node : Dom4JUtil.toNodeList(element.content())) {
            if (node instanceof Comment || node instanceof Element) {
                this.add(PoshiNodeFactory.newPoshiNode(node));
            }
            if (!(node instanceof CDATA)) continue;
            this.add((CDATA)new PoshiCDATA((CDATA)node.clone()));
        }
    }

    private boolean _isVarPoshiScriptSnippet(String poshiScriptSnippet) {
        if ((poshiScriptSnippet = StringUtil.trimLeading(poshiScriptSnippet)).startsWith("static") || poshiScriptSnippet.startsWith("var")) {
            Matcher matcher = _varNamePattern.matcher(poshiScriptSnippet);
            return matcher.find();
        }
        return false;
    }

    private String _removeEmptyLineBetweenVariables(String poshiScriptSnippet, PoshiNode<?, ?> poshiNode, PoshiNode<?, ?> previousPoshiNode) {
        Element element;
        if (previousPoshiNode == null || !this._isVarPoshiScriptSnippet(previousPoshiNode.toPoshiScript()) || !this._isVarPoshiScriptSnippet(poshiNode.toPoshiScript())) {
            return poshiScriptSnippet;
        }
        String previousVariableName = "";
        PoshiElement previousPoshiElement = (PoshiElement)previousPoshiNode;
        if (previousPoshiNode instanceof VarPoshiElement) {
            previousVariableName = previousPoshiElement.attributeValue("name");
        } else if (previousPoshiNode instanceof ExecutePoshiElement && (element = previousPoshiElement.element("return")) != null) {
            previousVariableName = element.attributeValue("name");
        }
        if (Validator.isNotNull(previousVariableName) && !poshiScriptSnippet.contains("${" + previousVariableName + "}")) {
            return poshiScriptSnippet.replaceFirst("\n\n", "\n");
        }
        return poshiScriptSnippet;
    }

    static {
        poshiScriptAnnotationPattern = Pattern.compile("@(?<name>[\\w-]*)[\\s]*?(\n|=[\\s](?<value>.*?)(?=[ \t]*\\n))", 32);
        poshiScriptBlockPattern = Pattern.compile("^[^{]*\\{[\\s\\S]*\\}$");
        INVOCATION_REGEX = "[\\s]*[\\w\\.]*\\((.*?|.*)\\)";
        varInvocationAssignmentStatementPattern = Pattern.compile("^((static[\\s]*|)var|)([\\s]*[A-Z][\\w]*|)[\\s]*[\\w]*[\\s]*=[\\s]*" + INVOCATION_REGEX + VAR_STATEMENT_END_REGEX, 40);
        _nestedConditionPattern = Pattern.compile("(\\|{2}|\\&{2})");
        _poshiScriptCommentPattern = Pattern.compile("^[\\s]*(\\/\\/.*?(\\n|$)|\\/\\*.*?\\*\\/)", 32);
        _varNamePattern = Pattern.compile(VAR_NAME_REGEX);
    }

    private class PropertyComparator
    implements Comparator<PoshiNode> {
        private PropertyComparator() {
        }

        @Override
        public int compare(PoshiNode poshiNode1, PoshiNode poshiNode2) {
            if (poshiNode1 instanceof PropertyPoshiElement && poshiNode2 instanceof PropertyPoshiElement) {
                PropertyPoshiElement propertyPoshiElement1 = (PropertyPoshiElement)poshiNode1;
                PropertyPoshiElement propertyPoshiElement2 = (PropertyPoshiElement)poshiNode2;
                String propertyName1 = propertyPoshiElement1.attributeValue("name");
                String propertyName2 = propertyPoshiElement2.attributeValue("name");
                return propertyName1.compareTo(propertyName2);
            }
            return 0;
        }
    }

    private class CommandComparator
    implements Comparator<PoshiNode> {
        private CommandComparator() {
        }

        @Override
        public int compare(PoshiNode poshiNode1, PoshiNode poshiNode2) {
            if (poshiNode1 instanceof CommandPoshiElement && poshiNode2 instanceof CommandPoshiElement) {
                CommandPoshiElement commandPoshiElement1 = (CommandPoshiElement)poshiNode1;
                CommandPoshiElement commandPoshiElement2 = (CommandPoshiElement)poshiNode2;
                String poshiScriptKeyword1 = commandPoshiElement1.getPoshiScriptKeyword();
                String poshiScriptKeyword2 = commandPoshiElement2.getPoshiScriptKeyword();
                String blockName1 = commandPoshiElement1.getBlockName();
                String blockName2 = commandPoshiElement2.getBlockName();
                NaturalOrderStringComparator naturalOrderStringComparator = new NaturalOrderStringComparator();
                if (blockName1.startsWith(poshiScriptKeyword1) && blockName2.startsWith(poshiScriptKeyword2) || !blockName1.startsWith(poshiScriptKeyword1) && !blockName2.startsWith(poshiScriptKeyword2)) {
                    return naturalOrderStringComparator.compare(blockName1, blockName2);
                }
                if (blockName1.startsWith(poshiScriptKeyword1) && !blockName2.startsWith(poshiScriptKeyword2)) {
                    return 1;
                }
                if (blockName2.startsWith(poshiScriptKeyword2) && !blockName1.startsWith(poshiScriptKeyword1)) {
                    return -1;
                }
                return naturalOrderStringComparator.compare(blockName1, blockName2);
            }
            return 0;
        }
    }
}

